/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.support.validator;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.enums.util.BaseEnumUtils;
import top.dingwen.io.treasure.mybatisplus.enums.DataBaseDataType;
import top.dingwen.io.treasure.mybatisplus.exception.TableStrFieldLengthValidException;
import top.dingwen.io.treasure.mybatisplus.model.TableFieldInfo;
import top.dingwen.io.treasure.mybatisplus.support.validator.IRangeValidator;

public abstract class AbstractRangeValidator
implements IRangeValidator {
    private static final Logger log = LoggerFactory.getLogger(AbstractRangeValidator.class);

    protected void numberRangeValid(TableFieldInfo tableFieldInfo, Object fieldValue) {
        DataBaseDataType dataType = (DataBaseDataType)BaseEnumUtils.fastFrom(DataBaseDataType.class, (Object)tableFieldInfo.getDataType());
        if (Objects.isNull((Object)dataType)) {
            return;
        }
        Long start = dataType.getStart();
        Long end = dataType.getEnd();
        Predicate<Long> predicateStart = val -> Long.compare(val, start) != -1;
        Predicate<Long> predicateEnd = val -> Long.compare(val, end) == 1;
        Long val2 = 0L;
        if (fieldValue instanceof Float || fieldValue instanceof Double || fieldValue instanceof BigDecimal) {
            val2 = Convert.toLong((Object)Convert.toStr((Object)fieldValue).length());
        } else if (fieldValue instanceof Integer || fieldValue instanceof Long) {
            val2 = Convert.toLong((Object)fieldValue);
        }
        if (predicateStart.test(val2) || predicateEnd.test(val2)) {
            String msg = StrUtil.format((CharSequence)"\u5b57\u6bb5:{}[{}]\u957f\u5ea6\u8d85\u51fa\u9650\u5236:[{},{}]", (Object[])new Object[]{tableFieldInfo.getColumnName(), tableFieldInfo.getColumnComment(), start, end});
            log.error("{},{},{}", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[AbstractRangeValidator]\u62bd\u8c61\u7684\u8303\u56f4\u68c0\u67e5\u5668", msg});
            throw new TableStrFieldLengthValidException(msg, StrUtil.toString((Object)fieldValue));
        }
    }
}

