/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.support.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import top.dingwen.io.treasure.enums.util.BaseEnumUtils;
import top.dingwen.io.treasure.mybatisplus.enums.DataBaseDataType;
import top.dingwen.io.treasure.mybatisplus.support.validator.IRangeValidator;

@Component
public class RangeValidFactory
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RangeValidFactory.class);
    protected static final Map<String, IRangeValidator> RANGE_VALIDATORS = new HashMap<String, IRangeValidator>(8);
    @Resource
    private ApplicationContext applicationContext;

    public void run(ApplicationArguments args) {
        Map rangeValidators = this.applicationContext.getBeansOfType(IRangeValidator.class);
        for (Map.Entry entry : rangeValidators.entrySet()) {
            IRangeValidator rangeValidator = (IRangeValidator)entry.getValue();
            RANGE_VALIDATORS.put(rangeValidator.getType().getCode().concat("range_valid"), rangeValidator);
            log.info("{},{},\u957f\u5ea6\u6821\u9a8c\u670d\u52a1:{},\u5df2\u6210\u529f\u52a0\u8f7d", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[RangeValidFactory]\u6570\u636e\u6821\u9a8c\u5de5\u5382", rangeValidator.getClass().getSimpleName()});
        }
    }

    public static Optional<IRangeValidator> get(String dataType) {
        DataBaseDataType dataBaseDataType = (DataBaseDataType)BaseEnumUtils.fastFrom(DataBaseDataType.class, (Object)dataType);
        if (Objects.isNull(dataBaseDataType.getStart()) || Objects.isNull(dataBaseDataType.getEnd())) {
            dataType = DataBaseDataType.VARCHAR.getCode();
        } else {
            if (-1L == dataBaseDataType.getStart() || -1L == dataBaseDataType.getEnd()) {
                return Optional.empty();
            }
            dataType = DataBaseDataType.INT.getCode();
        }
        IRangeValidator rangeValidator = RANGE_VALIDATORS.get(dataType.concat("range_valid"));
        if (Objects.isNull(rangeValidator)) {
            log.error("{},{},\u672a\u627e\u5230{}{}\u957f\u5ea6\u6821\u9a8c\u670d\u52a1,\u6821\u9a8c\u5931\u6548", new Object[]{dataType, "[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[RangeValidFactory]\u6570\u636e\u6821\u9a8c\u5de5\u5382", "range_valid"});
            return Optional.empty();
        }
        return Optional.of(rangeValidator);
    }
}

