/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.support.validator.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import top.dingwen.io.treasure.mybatisplus.enums.DataBaseDataType;
import top.dingwen.io.treasure.mybatisplus.exception.TableStrFieldLengthValidException;
import top.dingwen.io.treasure.mybatisplus.model.TableFieldInfo;
import top.dingwen.io.treasure.mybatisplus.support.validator.AbstractRangeValidator;

@Component
public class StringRangeValidatorImpl
extends AbstractRangeValidator {
    private static final Logger log = LoggerFactory.getLogger(StringRangeValidatorImpl.class);

    @Override
    public void valid(TableFieldInfo tableFieldInfo, Object fieldValue) {
        String realValue = Convert.toStr((Object)fieldValue);
        int valueLen = realValue.length();
        Long maxLen = tableFieldInfo.getCharacterMaximumLength();
        if (Objects.nonNull(maxLen) && (long)valueLen > maxLen) {
            String msg = StrUtil.format((CharSequence)"\u5b57\u6bb5:{}[{}]\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7:{}", (Object[])new Object[]{tableFieldInfo.getColumnName(), tableFieldInfo.getColumnComment(), maxLen});
            log.error("{},{},{}", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[StringRangeValidatorImpl]\u5b57\u7b26\u4e32\u957f\u5ea6\u6821\u9a8c\u7ec4\u4ef6", msg});
            throw new TableStrFieldLengthValidException(msg, realValue);
        }
    }

    @Override
    public DataBaseDataType getType() {
        return DataBaseDataType.VARCHAR;
    }
}

