/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.base.util.stream.StreamUtils;
import top.dingwen.io.treasure.mybatisplus.model.TableFieldInfo;
import top.dingwen.io.treasure.mybatisplus.util.MysqlTableInfoUtils;

public class CompareUtils {
    private static final Logger log = LoggerFactory.getLogger(CompareUtils.class);
    public static final String CHANGE_CONTENT = "\u5b57\u6bb5\u540d\u79f0:\u3010{}\u3011,\u5b57\u6bb5\u63cf\u8ff0:\u3010{}\u3011,\u7531\u3010{}\u3011\u53d8\u66f4\u4e3a\u3010{}\u3011\u3002";
    public static final String CHANGE_SIMPLE_CONTENT = "\u3010{}\u3011\u7531\u3010{}\u3011\u53d8\u66f4\u4e3a\u3010{}\u3011\u3002";

    public static <T> String getChangeContent(String dataInfo, String tableName, T oldData, T newData, Map<String, Function<Object, Object>> fieldConverts, List<TableFieldInfo> extFields, Boolean contentSimpleFlag, List<String> ignores) {
        List tableFieldInfos = MysqlTableInfoUtils.getTableFieldInfos(tableName);
        if (CollUtil.isNotEmpty(extFields)) {
            tableFieldInfos.addAll(extFields);
        }
        if (CollUtil.isEmpty(tableFieldInfos)) {
            log.info("[\u5b57\u6bb5\u6bd4\u8f83\u5de5\u5177]\t\u672a\u83b7\u53d6\u5230\u8868\u4fe1\u606f\uff0c\u53d6\u6d88\u6bd4\u8f83");
            return null;
        }
        Map oldDataMap = BeanUtil.beanToMap(oldData, (boolean)false, (boolean)true);
        Map newDataMap = BeanUtil.beanToMap(newData, (boolean)false, (boolean)true);
        if (CollUtil.isNotEmpty(ignores)) {
            tableFieldInfos = tableFieldInfos.stream().filter(f -> !ignores.contains(f.getColumnName())).collect(Collectors.toList());
        }
        StringBuilder content = new StringBuilder(dataInfo.concat(","));
        tableFieldInfos = StreamUtils.distinct(tableFieldInfos, TableFieldInfo::getColumnName);
        for (TableFieldInfo tableFieldInfo : tableFieldInfos) {
            String columnName = tableFieldInfo.getColumnName();
            Function<Object, Object> func = null;
            if (CollUtil.isNotEmpty(fieldConverts)) {
                func = fieldConverts.get(columnName);
            }
            content = CompareUtils.compare(content, tableFieldInfo, oldDataMap.get(columnName), newDataMap.get(columnName), func, contentSimpleFlag);
        }
        if (dataInfo.concat(",").length() == content.length()) {
            return null;
        }
        return content.toString();
    }

    public static StringBuilder compare(StringBuilder content, TableFieldInfo tableFieldInfo, Object oldData, Object newData, Function<Object, Object> convertFunc, Boolean contentSimpleFlag) {
        if (Objects.isNull(tableFieldInfo) || Objects.isNull(oldData) || Objects.isNull(newData)) {
            return content;
        }
        if (!oldData.equals(newData)) {
            if (Objects.nonNull(convertFunc)) {
                oldData = convertFunc.apply(oldData);
                newData = convertFunc.apply(newData);
            }
            if (Boolean.TRUE.equals(contentSimpleFlag)) {
                return content.append(CharSequenceUtil.format((CharSequence)CHANGE_SIMPLE_CONTENT, (Object[])new Object[]{tableFieldInfo.getColumnComment(), oldData, newData}));
            }
            return content.append(CharSequenceUtil.format((CharSequence)CHANGE_CONTENT, (Object[])new Object[]{tableFieldInfo.getColumnName(), tableFieldInfo.getColumnComment(), oldData, newData}));
        }
        return content;
    }

    private CompareUtils() {
    }
}

