/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.base.util.stream.StreamUtils;
import top.dingwen.io.treasure.mybatisplus.exception.TableStrFieldLengthValidException;
import top.dingwen.io.treasure.mybatisplus.model.TableFieldInfo;

public class MysqlTableInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(MysqlTableInfoUtils.class);
    private static final Map<String, List<TableFieldInfo>> CACHE_TABLE_FIELD_INFO = new HashMap<String, List<TableFieldInfo>>(16);
    private static final Map<String, String> CACHE_TABLE_INFO = new HashMap<String, String>(16);
    private static final String MYSQL_QUERY_TABLE_INFO = "show table status from {} where name='{}'";
    private static final String MYSQL_QUERY_SQL = "SELECT column_name  AS column_name, data_type AS data_type, character_maximum_length AS character_maximum_length,column_comment AS column_comment FROM INFORMATION_SCHEMA.COLUMNS  WHERE table_name = '{}'";
    private static final String COLUMN_NAME = "column_name";
    private static final String DATA_TYPE = "data_type";
    private static final String CHARACTER_MAXIMUM_LENGTH = "character_maximum_length";
    private static final String COLUMN_COMMENT = "column_comment";
    private static final String TABLE_COMMENT = "Comment";

    public static <T> String getTableName(T obj) {
        if (Objects.isNull(obj)) {
            throw new TableStrFieldLengthValidException("\u5b9e\u4f53\u5bf9\u8c61\u7a7a");
        }
        Object[] annotations = obj.getClass().getAnnotations();
        if (ArrayUtil.isEmpty((Object[])annotations)) {
            log.error("{},{},\u7c7b\u540d\u79f0{},\u5b9e\u4f53\u5bf9\u8c61\u7f3a\u5931TableName\u5173\u952e\u6ce8\u89e3\u4fe1\u606f", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MysqlTableInfoUtils]\u83b7\u53d6\u8868\u4fe1\u606f\u5de5\u5177", obj.getClass().getSimpleName()});
            throw new TableStrFieldLengthValidException("\u5b9e\u4f53\u5bf9\u8c61\u7f3a\u5931\u5173\u952e\u6ce8\u89e3\u4fe1\u606f", "@TableName");
        }
        for (Object annotation : annotations) {
            if (!(annotation instanceof TableName)) continue;
            return ((TableName)annotation).value();
        }
        log.error("{},{},\u7c7b\u540d\u79f0{},\u5b9e\u4f53\u5bf9\u8c61\u7f3a\u5931TableName\u5173\u952e\u6ce8\u89e3\u4fe1\u606f", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MysqlTableInfoUtils]\u83b7\u53d6\u8868\u4fe1\u606f\u5de5\u5177", obj.getClass().getSimpleName()});
        throw new TableStrFieldLengthValidException("\u5b9e\u4f53\u5bf9\u8c61\u7f3a\u5931\u5173\u952e\u6ce8\u89e3\u4fe1\u606f", "@TableName");
    }

    public static List<TableFieldInfo> getTableFieldInfos(String tableName) {
        List<TableFieldInfo> tableFieldInfosCache = CACHE_TABLE_FIELD_INFO.get(tableName);
        if (CollUtil.isNotEmpty(tableFieldInfosCache)) {
            return tableFieldInfosCache;
        }
        String querySql = CharSequenceUtil.format((CharSequence)MYSQL_QUERY_SQL, (Object[])new Object[]{tableName});
        log.info("{},{}\uff0c\u6700\u7ec8\u67e5\u8be2SQL:{}", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MysqlTableInfoUtils]\u83b7\u53d6\u8868\u4fe1\u606f\u5de5\u5177", querySql});
        try {
            List tableFieldInfosDb = SqlRunner.db().selectList(querySql, new Object[0]).stream().map(m -> TableFieldInfo.builder().columnName(CharSequenceUtil.toCamelCase((CharSequence)Convert.toStr(m.get(COLUMN_NAME)))).dataType(Convert.toStr(m.get(DATA_TYPE))).characterMaximumLength(Convert.toLong(m.get(CHARACTER_MAXIMUM_LENGTH))).columnComment(Convert.toStr(m.get(COLUMN_COMMENT))).build()).collect(Collectors.toList());
            tableFieldInfosDb = StreamUtils.distinct(tableFieldInfosDb, TableFieldInfo::getColumnName);
            CACHE_TABLE_FIELD_INFO.put(tableName, tableFieldInfosDb);
            return tableFieldInfosDb;
        }
        catch (Exception e) {
            throw new RuntimeException("[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668[MysqlTableInfoUtils]\u83b7\u53d6\u8868\u4fe1\u606f\u5de5\u5177SQL\u6267\u884c\u5f02\u5e38,\u8bf7\u68c0\u67e5:" + querySql);
        }
    }

    public static String getTableComment(String tableName, String database) {
        String tableCommentCache = CACHE_TABLE_INFO.get(tableName);
        if (CharSequenceUtil.isNotBlank((CharSequence)tableCommentCache)) {
            return tableCommentCache;
        }
        String querySql = CharSequenceUtil.format((CharSequence)MYSQL_QUERY_TABLE_INFO, (Object[])new Object[]{database, tableName});
        log.info("{},{}\uff0c\u6700\u7ec8\u67e5\u8be2SQL:{}", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MysqlTableInfoUtils]\u83b7\u53d6\u8868\u4fe1\u606f\u5de5\u5177", querySql});
        try {
            Map infos = SqlRunner.db().selectOne(querySql, new Object[0]);
            if (CollUtil.isNotEmpty((Map)infos)) {
                String tableCommentDb = Convert.toStr(infos.get(TABLE_COMMENT));
                CACHE_TABLE_INFO.put(tableName, tableCommentDb);
                return tableCommentDb;
            }
        }
        catch (Exception e) {
            log.error("{},{},\uff0cSQL\u6267\u884c\u5f02\u5e38,\u8bf7\u68c0\u67e5:\n{}", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MysqlTableInfoUtils]\u83b7\u53d6\u8868\u4fe1\u606f\u5de5\u5177", querySql});
            throw new RuntimeException("[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668[MysqlTableInfoUtils]\u83b7\u53d6\u8868\u4fe1\u606f\u5de5\u5177SQL\u6267\u884c\u5f02\u5e38,\u8bf7\u68c0\u67e5:" + querySql);
        }
        return null;
    }

    private MysqlTableInfoUtils() {
    }
}

