/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import top.dingwen.io.treasure.base.util.reflect.ReflectUtils;
import top.dingwen.io.treasure.mybatisplus.annotation.QueryType;
import top.dingwen.io.treasure.mybatisplus.enums.QueryMode;
import top.dingwen.io.treasure.mybatisplus.web.query.BaseQuery;

public class QueryUtils {
    private static final String DATA_SCOPE = "dataScope";
    private static final List<String> DEFAULT_FILTER_FIELDS = Arrays.asList("serialVersionUID", "pageSize", "pageNum");

    public static <T> QueryWrapper<T> buildQueryWrapper(BaseQuery query, String ... ignore) {
        Field[] fields;
        List filterFields = Arrays.stream(ignore).collect(Collectors.toList());
        filterFields.addAll(DEFAULT_FILTER_FIELDS);
        QueryWrapper queryWrapper = new QueryWrapper();
        block11: for (Field field2 : fields = ReflectUtils.getFields(query.getClass(), field -> !filterFields.contains(field.getName()))) {
            ReflectUtils.setAccessible((AccessibleObject)field2);
            QueryType queryType = field2.getAnnotation(QueryType.class);
            if (Objects.isNull(queryType)) {
                QueryUtils.buildQueryWrapperDefaultCondition(field2, query, queryWrapper);
                continue;
            }
            QueryMode queryMode = queryType.value();
            if (Objects.isNull((Object)queryMode)) {
                QueryUtils.buildQueryWrapperDefaultCondition(field2, query, queryWrapper);
                continue;
            }
            switch (queryMode) {
                case EQ: {
                    QueryUtils.buildQueryWrapperEqCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case FULL: {
                    QueryUtils.buildQueryWrapperFullCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case LEFT: {
                    QueryUtils.buildQueryWrapperLeftCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case RIGHT: {
                    QueryUtils.buildQueryWrapperRightCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case IN: {
                    QueryUtils.buildQueryWrapperInCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case NOT_IN: {
                    QueryUtils.buildQueryWrapperNotInCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case ASC: {
                    QueryUtils.buildQueryWrapperAscCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case DESC: {
                    QueryUtils.buildQueryWrapperDescCondition(field2, query, queryWrapper);
                    continue block11;
                }
                case RANGE: {
                    Field endField;
                    String endPropertyName = queryType.name();
                    String columnName = queryType.columnName();
                    if (StrUtil.isBlank((CharSequence)endPropertyName) || StrUtil.isBlank((CharSequence)columnName) || Objects.isNull(endField = ReflectUtils.getField(BaseQuery.class, (String)endPropertyName))) continue block11;
                    QueryUtils.buildQueryWrapperRangeCondition(field2, endField, query, columnName, queryWrapper);
                    continue block11;
                }
                default: {
                    QueryUtils.buildQueryWrapperDefaultCondition(field2, query, queryWrapper);
                }
            }
        }
        String dataScopeSql = (String)Optional.of(query).map(BaseQuery::getParams).map(p -> p.get(DATA_SCOPE)).orElse("");
        queryWrapper.last(dataScopeSql);
        return queryWrapper;
    }

    private static Pair<Boolean, Object> judgeMappingCondition(Field field, BaseQuery query) {
        Object val = field.get(query);
        if (Objects.isNull(val)) {
            return new Pair((Object)Boolean.FALSE, null);
        }
        if (val instanceof String && StrUtil.isBlank((CharSequence)Convert.toStr((Object)val))) {
            return new Pair((Object)Boolean.FALSE, null);
        }
        if (val instanceof Collection && CollUtil.isEmpty((Collection)((Collection)val))) {
            return new Pair((Object)Boolean.FALSE, null);
        }
        return new Pair((Object)Boolean.TRUE, val);
    }

    private static <T> QueryWrapper<T> buildQueryWrapperRangeCondition(Field startField, Field endField, BaseQuery query, String columnName, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResultStart = QueryUtils.judgeMappingCondition(startField, query);
        Pair<Boolean, Object> judgeResultEnd = QueryUtils.judgeMappingCondition(endField, query);
        if (Boolean.TRUE.equals((Boolean)judgeResultStart.getKey() == false) || Boolean.TRUE.equals((Boolean)judgeResultEnd.getKey() == false)) {
            return queryWrapper;
        }
        queryWrapper.between((Object)columnName, judgeResultStart.getValue(), judgeResultEnd.getValue());
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperLeftCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResult = QueryUtils.judgeMappingCondition(field, query);
        if (Boolean.FALSE.equals(judgeResult.getKey())) {
            return queryWrapper;
        }
        queryWrapper.likeLeft((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()), judgeResult.getValue());
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperAscCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        queryWrapper.orderByAsc((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()));
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperDescCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        queryWrapper.orderByDesc((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()));
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperInCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResult = QueryUtils.judgeMappingCondition(field, query);
        if (!((Boolean)judgeResult.getKey()).booleanValue()) {
            return queryWrapper;
        }
        queryWrapper.in((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()), new Object[]{judgeResult.getValue()});
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperNotInCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResult = QueryUtils.judgeMappingCondition(field, query);
        if (Boolean.FALSE.equals(judgeResult.getKey())) {
            return queryWrapper;
        }
        queryWrapper.notIn((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()), new Object[]{judgeResult.getValue()});
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperRightCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResult = QueryUtils.judgeMappingCondition(field, query);
        if (Boolean.FALSE.equals(judgeResult.getKey())) {
            return queryWrapper;
        }
        queryWrapper.likeRight((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()), judgeResult.getValue());
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperFullCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResult = QueryUtils.judgeMappingCondition(field, query);
        if (Boolean.FALSE.equals(judgeResult.getKey())) {
            return queryWrapper;
        }
        queryWrapper.like((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()), judgeResult.getValue());
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperEqCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResult = QueryUtils.judgeMappingCondition(field, query);
        if (Boolean.FALSE.equals(judgeResult.getKey())) {
            return queryWrapper;
        }
        queryWrapper.eq((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()), judgeResult.getValue());
        return queryWrapper;
    }

    private static <T> QueryWrapper<T> buildQueryWrapperDefaultCondition(Field field, BaseQuery query, QueryWrapper queryWrapper) {
        Pair<Boolean, Object> judgeResult = QueryUtils.judgeMappingCondition(field, query);
        if (Boolean.FALSE.equals(judgeResult.getKey())) {
            return queryWrapper;
        }
        queryWrapper.eq((Object)StrUtil.toUnderlineCase((CharSequence)field.getName()), judgeResult.getValue());
        return queryWrapper;
    }

    private QueryUtils() {
    }
}

