/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.config;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;
import top.dingwen.io.treasure.base.support.ICurrentUserService;
import top.dingwen.io.treasure.mybatisplus.model.entity.BaseEntity;

@Component
public class MybatisPlusMetaObjectHandler
implements MetaObjectHandler {
    @Resource
    private ICurrentUserService currentUserService;

    public void insertFill(MetaObject metaObject) {
        this.decisionIsUseDefaultForInsert(metaObject);
    }

    public void updateFill(MetaObject metaObject) {
        this.decisionIsUseDefaultForUpdate(metaObject);
    }

    private void decisionIsUseDefaultForInsert(MetaObject metaObject) {
        Optional<BaseEntity> baseEntityOp = this.getBaseEntity(metaObject);
        if (baseEntityOp.isPresent()) {
            BaseEntity baseEntity = baseEntityOp.get();
            if (CharSequenceUtil.isBlank((CharSequence)baseEntity.getCreateBy())) {
                baseEntity.setCreateBy(this.currentUserService.getUserName());
            }
            if (ObjectUtil.isNull((Object)baseEntity.getCreateTime())) {
                baseEntity.setCreateTime(LocalDateTime.now());
            }
        }
    }

    private void decisionIsUseDefaultForUpdate(MetaObject metaObject) {
        Optional<BaseEntity> baseEntityOp = this.getBaseEntity(metaObject);
        if (baseEntityOp.isPresent()) {
            BaseEntity baseEntity = baseEntityOp.get();
            if (CharSequenceUtil.isBlank((CharSequence)baseEntity.getUpdateBy())) {
                baseEntity.setUpdateBy(this.currentUserService.getUserName());
            }
            if (ObjectUtil.isNull((Object)baseEntity.getUpdateTime())) {
                baseEntity.setUpdateTime(LocalDateTime.now());
            }
        }
    }

    private Optional<BaseEntity> getBaseEntity(MetaObject metaObject) {
        if (ObjectUtil.isNotNull((Object)metaObject) && metaObject.getOriginalObject() instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)metaObject.getOriginalObject();
            return Optional.ofNullable(baseEntity);
        }
        return Optional.empty();
    }
}

