/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.interceptor;

import cn.hutool.core.convert.Convert;
import cn.hutool.extra.spring.SpringUtil;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MybatisSqlStatementInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisSqlStatementInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        long startTime = System.currentTimeMillis();
        String methodName = invocation.getMethod().getName();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            long timeConsuming = System.currentTimeMillis() - startTime;
            log.info("[MybatisPlus\u573a\u666f\u542f\u52a8\u5668]\t[{}] \t \u6267\u884cSQL:{}ms", (Object)methodName, (Object)timeConsuming);
            Long consumeLow = Convert.toLong((Object)SpringUtil.getProperty((String)"honest.sqlLog.consume.low"), (Long)999L);
            Long consumeMiddle = Convert.toLong((Object)SpringUtil.getProperty((String)"honest.sqlLog.consume.middle"), (Long)5000L);
            Long consumeHeight = Convert.toLong((Object)SpringUtil.getProperty((String)"honest.sqlLog.consume.height"), (Long)10000L);
            if (timeConsuming > consumeLow && timeConsuming < consumeMiddle) {
                log.info("[MybatisPlus\u573a\u666f\u542f\u52a8\u5668]\t[{}] \t \u6267\u884cSQL\u5927\u4e8e1s:{}ms", (Object)methodName, (Object)timeConsuming);
            } else if (timeConsuming >= consumeMiddle && timeConsuming < consumeHeight) {
                log.info("[MybatisPlus\u573a\u666f\u542f\u52a8\u5668]\t[{}] \t \u6267\u884cSQL\u5927\u4e8e5s:{}ms", (Object)methodName, (Object)timeConsuming);
            } else if (timeConsuming >= consumeHeight) {
                log.info("[MybatisPlus\u573a\u666f\u542f\u52a8\u5668]\t[{}] \t \u6267\u884cSQL\u5927\u4e8e10s:{}ms", (Object)methodName, (Object)timeConsuming);
            }
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        log.info("[mybatisplus] MybatisSqlStatementInterceptor setProperties");
    }
}

