/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.util;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.base.util.reflect.ReflectUtils;
import top.dingwen.io.treasure.mybatisplus.model.TableFieldInfo;
import top.dingwen.io.treasure.mybatisplus.support.validator.IRangeValidator;
import top.dingwen.io.treasure.mybatisplus.support.validator.RangeValidFactory;
import top.dingwen.io.treasure.mybatisplus.util.MysqlTableInfoUtils;

public class TableFieldLengthValidHelper {
    private static final Logger log = LoggerFactory.getLogger(TableFieldLengthValidHelper.class);

    public static <T> void valid(T obj) {
        String tableName = MysqlTableInfoUtils.getTableName(obj);
        List<TableFieldInfo> tableFieldInfos = MysqlTableInfoUtils.getTableFieldInfos(tableName);
        Class<?> clazz = obj.getClass();
        for (TableFieldInfo tableFieldInfo : tableFieldInfos) {
            Field field = ReflectUtils.getField(clazz, (String)tableFieldInfo.getColumnName());
            field.setAccessible(true);
            TableFieldLengthValidHelper.checkField(field, tableFieldInfo, field.get(obj));
        }
    }

    public static void checkField(Field field, TableFieldInfo fieldInfo, Object fieldValue) {
        if (Objects.isNull(field)) {
            return;
        }
        String fieldTypeName = field.getType().getName();
        if (!String.class.getName().equals(fieldTypeName)) {
            return;
        }
        String fieldName = field.getName();
        if (Objects.isNull(fieldInfo)) {
            return;
        }
        field.setAccessible(true);
        if (Objects.isNull(fieldValue)) {
            return;
        }
        Optional<IRangeValidator> rangeValidator = RangeValidFactory.get(fieldInfo.getDataType());
        rangeValidator.ifPresent(iRangeValidator -> iRangeValidator.valid(fieldInfo, fieldValue));
    }

    private TableFieldLengthValidHelper() {
    }
}

