/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.web.mybatisplus;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import top.dingwen.io.treasure.mybatisplus.model.entity.BaseEntity;
import top.dingwen.io.treasure.mybatisplus.util.MyPageHelper;
import top.dingwen.io.treasure.webplus.model.vo.PageVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.web.controller.BaseCrudController;
import top.dingwen.io.treasure.webplus.web.controller.BaseViewController;

public abstract class AbstractBaseControllerMybatisPlusImpl<P extends BaseEntity>
implements BaseCrudController<P>,
BaseViewController {
    @Autowired
    private IService<P> iService;

    @GetMapping(value={"/default/{id}"})
    public ResultVO find(@PathVariable Serializable id) {
        return this.success(this.iService.getById(id));
    }

    @GetMapping(value={"/default/page"})
    public ResultVO<PageVO<P>> findPage(@ModelAttribute P p) {
        MyPageHelper.startPage();
        List ps = this.iService.list((Wrapper)new QueryWrapper(p));
        long count = this.iService.count((Wrapper)new QueryWrapper(p));
        return this.page(ps, count);
    }

    @GetMapping(value={"/default/{ids}"})
    public ResultVO<List<P>> find(@PathVariable List<Serializable> ids) {
        return this.success(this.iService.listByIds(ids));
    }

    @GetMapping(value={"/default/count"})
    public ResultVO<Long> count() {
        return this.success(this.iService.count());
    }

    @GetMapping(value={"/default/exists/{id}"})
    public ResultVO<Boolean> exists(@PathVariable Serializable id) {
        return this.success(ObjectUtil.isEmpty((Object)this.iService.getById(id)));
    }

    @PutMapping(value={"/default"})
    public ResultVO<Boolean> modify(@RequestBody P p) {
        return this.genResult(this.iService.updateById(p));
    }

    @PostMapping(value={"/default"})
    public ResultVO create(@RequestBody P p) {
        return this.genResult(this.iService.save(p));
    }

    @PostMapping(value={"/default/batch"})
    public ResultVO<Boolean> create(@RequestBody List<P> ps) {
        return this.genResult(this.iService.saveBatch(ps));
    }

    @DeleteMapping(value={"/default/{id}"})
    public ResultVO<Boolean> remove(@PathVariable Serializable id) {
        return this.genResult(this.iService.removeById(id));
    }

    @DeleteMapping(value={"/default/batch/{ids}"})
    public ResultVO<Boolean> remove(@PathVariable List<Serializable> ids) {
        return this.genResult(this.iService.removeByIds(ids));
    }

    @PostMapping(value={"/default/sa-mos"})
    public ResultVO<Boolean> saveOrUpdate(P p) {
        return this.genResult(this.iService.saveOrUpdate(p));
    }
}

