/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.aspect;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.redis.annotation.DelayRemoves;
import top.dingwen.io.treasure.redis.core.RedisServiceImpl;

@Aspect
public class DelayRemovesAspect {
    private static final Logger log = LoggerFactory.getLogger(DelayRemovesAspect.class);
    @Resource
    private RedisServiceImpl redisServiceImpl;
    @Resource
    private ScheduledExecutorService scheduledExecutorService;

    @Around(value="@annotation(delayRemoves)")
    public Object aroundAdvice(ProceedingJoinPoint proceedingJoinPoint, DelayRemoves delayRemoves) {
        String keyPattern = delayRemoves.keyPattern();
        this.redisServiceImpl.removeKeys(keyPattern);
        Object proceed = null;
        try {
            proceed = proceedingJoinPoint.proceed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long time = delayRemoves.time();
        this.scheduledExecutorService.schedule(() -> this.redisServiceImpl.removeKeys(keyPattern), time, TimeUnit.MILLISECONDS);
        return proceed;
    }
}

