/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.aspect;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.base.util.aspect.AspectUtils;
import top.dingwen.io.treasure.redis.annotation.EasyCache;
import top.dingwen.io.treasure.redis.core.RedisServiceImpl;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVOGenerator;

@Aspect
public class EasyCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(EasyCacheAspect.class);
    @Resource
    private RedisServiceImpl redisServiceImpl;
    private final AtomicInteger atomicInteger = new AtomicInteger(2);
    private String redisKey = "";
    private ProceedingJoinPoint joinPoint;
    private EasyCache easyCache;
    private String fullClassName;
    private String methodName;
    private Object[] args;

    private void init(ProceedingJoinPoint joinPoint, EasyCache easyCache) {
        this.joinPoint = joinPoint;
        this.easyCache = easyCache;
        this.fullClassName = this.getClassName();
        this.methodName = this.getMethodName();
        this.args = joinPoint.getArgs();
    }

    @Around(value="@annotation(easyCache)")
    public Object doAround(ProceedingJoinPoint joinPoint, EasyCache easyCache) {
        Object returnObject;
        Object cacheData;
        if ("java.lang.Void".equals(easyCache.returnType().getName())) {
            log.error("[redis]\u573a\u666f,[EasyCache],\u65b9\u6cd5\u8fd4\u56de\u503c\u4e3a\u7a7a\u4e0d\u9700\u8981\u8fdb\u884c\u7f13\u5b58\u5904\u7406");
            return null;
        }
        int step = 3;
        if (this.atomicInteger.incrementAndGet() % step == 0) {
            this.init(joinPoint, easyCache);
            this.redisKey = this.generateKey();
        }
        if (ObjectUtil.isNotNull(cacheData = this.redisServiceImpl.getCacheObject(this.redisKey))) {
            if (easyCache.printedLog()) {
                log.info("[redis]\u573a\u666f,[EasyCache],\u7c7b\uff1a{},\u65b9\u6cd5\uff1a{},key\uff1a{},\u7f13\u5b58\u547d\u4e2d,\u65b9\u6cd5\u5165\u53c2\uff1a{},\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{this.fullClassName, this.methodName, this.redisKey, this.args, cacheData});
            }
            return ResultVOGenerator.genSuccessResult(cacheData, (String)"[redis]\u573a\u666f,EasyCache \u7f13\u5b58\u547d\u4e2d\u8fd4\u56de");
        }
        try {
            returnObject = Convert.convert((Class)easyCache.returnType(), (Object)joinPoint.proceed());
        }
        catch (Throwable e) {
            log.error("[redis]\u573a\u666f,[EasyCache],\u7c7b\uff1a{},\u65b9\u6cd5\uff1a{},key\uff1a{},\u65b9\u6cd5\u5165\u53c2: {}\u5c1d\u8bd5\u83b7\u53d6\u65b9\u6cd5\u8fd4\u56de\u503c\u7c7b\u578b\u6216\u6267\u884c\u539f\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\uff0cmessage\uff1a{}", new Object[]{this.fullClassName, this.methodName, this.redisKey, this.args, e.getMessage()});
            return null;
        }
        if (ObjectUtil.isNull((Object)returnObject)) {
            log.error("[redis]\u573a\u666f,[EasyCache],\u7c7b\uff1a{},\u65b9\u6cd5\uff1a{},key\uff1a{},\u7f13\u5b58\u672a\u547d\u4e2d,\u6267\u884c\u539f\u65b9\u6cd5\u8fd4\u56de\u503c\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u7f13\u5b58,\u65b9\u6cd5\u5165\u53c2: {}", new Object[]{this.fullClassName, this.methodName, this.redisKey, this.args});
            return null;
        }
        if (easyCache.printedLog()) {
            log.info("[redis]\u573a\u666f,[EasyCache],\u7f13\u5b58key:{}\uff0c,\u6709\u6548\u671f\uff1a{} {}", new Object[]{this.redisKey, easyCache.time(), easyCache.unit()});
        }
        if (returnObject instanceof ResultVO) {
            ResultVO resultVO = (ResultVO)returnObject;
            Object data = resultVO.getData();
            this.redisServiceImpl.setCacheObject(this.redisKey, JSONUtil.toJsonStr((Object)data), easyCache.time(), easyCache.unit());
            return ResultVOGenerator.genSuccessResult((Object)data);
        }
        this.redisServiceImpl.setCacheObject(this.redisKey, JSONUtil.toJsonStr((Object)returnObject), easyCache.time(), easyCache.unit());
        return ResultVOGenerator.genSuccessResult((Object)returnObject);
    }

    private String generateKey() {
        String[] keyParamValues = this.getKeyParamValues();
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(this.fullClassName).append(":").append(this.methodName);
        if (keyParamValues.length == 0) {
            keyParamValues[0] = this.easyCache.keyParams()[0];
        }
        Arrays.asList(keyParamValues).forEach(param -> {
            keyBuilder.append(":");
            keyBuilder.append((String)param);
        });
        if (this.easyCache.printedLog()) {
            log.info("[redis]\u573a\u666f,[EasyCache],\u901a\u8fc7\u6ce8\u89e3\u83b7\u53d6\u65b9\u6cd5\u771f\u5b9e\u53c2\u6570\uff0c\u751f\u6210\u7f13\u5b58key\uff0c\u771f\u5b9e\u65b9\u6cd5\u53c2\u6570\uff1a {}", (Object)keyParamValues);
        }
        return keyBuilder.toString();
    }

    private String[] getKeyParamValues() {
        String[] formalParameterNames = AspectUtils.getFormalParameterNames((ProceedingJoinPoint)this.joinPoint);
        int length = this.easyCache.keyParams().length;
        String[] keyParamValues = new String[length];
        for (int i = length - 1; i >= 0; --i) {
            String paramPlaceholder = this.easyCache.keyParams()[i];
            Integer index = AspectUtils.getIndexForKeyParamsInFormalParameterNames((String)paramPlaceholder, (String[])formalParameterNames);
            keyParamValues[i] = (String)AspectUtils.getValue((String)paramPlaceholder, (String)formalParameterNames[index], (Object)this.args[index], String.class);
        }
        return keyParamValues;
    }

    private String getClassName() {
        return this.joinPoint.getSourceLocation().getWithinType().getName();
    }

    private String getMethodName() {
        return this.joinPoint.getSignature().getName();
    }
}

