/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.aspect;

import cn.hutool.extra.servlet.ServletUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import top.dingwen.io.treasure.base.util.str.StringPlusUtils;
import top.dingwen.io.treasure.redis.annotation.RateLimiter;
import top.dingwen.io.treasure.redis.core.RedisServiceImpl;
import top.dingwen.io.treasure.redis.enums.LimitType;
import top.dingwen.io.treasure.redis.exception.RateLimiterException;
import top.dingwen.io.treasure.webplus.util.servlet.ServletUtils;

@Aspect
@Component
public class RateLimiterAspect {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterAspect.class);
    @Resource
    private RedisServiceImpl redisServiceImpl;
    @Resource
    private RedisScript<Long> limitScript;

    @Before(value="@annotation(rateLimiter)")
    public void doBefore(JoinPoint point, RateLimiter rateLimiter) {
        int time = rateLimiter.time();
        int count = rateLimiter.count();
        String combineKey = this.getCombineKey(rateLimiter, point);
        List<Object> keys = Collections.singletonList(combineKey);
        Long number = this.redisServiceImpl.execute(this.limitScript, keys, count, time);
        log.info("[redis]\u573a\u666f,[rateLimiter]\u9650\u5236\u8bf7\u6c42'{}',\u5f53\u524d\u8bf7\u6c42'{}',\u7f13\u5b58key'{}'", new Object[]{count, number.intValue(), combineKey});
        if (ObjectUtils.isEmpty((Object)number) || number.intValue() > count) {
            throw new RateLimiterException("[redis]\u573a\u666f", "\u8bbf\u95ee\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
        }
    }

    public String getCombineKey(RateLimiter rateLimiter, JoinPoint point) {
        String key = rateLimiter.key();
        if (!":".equals(StringPlusUtils.substring((String)key, (int)(key.length() - 1)))) {
            key = key.concat(":");
        }
        StringBuilder stringBuffer = new StringBuilder(key);
        if (rateLimiter.limitType().equals((Object)LimitType.IP)) {
            stringBuffer.append(ServletUtil.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0])).append(":");
        }
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Class<?> targetClass = method.getDeclaringClass();
        stringBuffer.append(StringPlusUtils.replace((String)targetClass.getName(), (String)".", (String)":")).append(":").append(method.getName());
        return stringBuffer.toString();
    }
}

