/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.aspect;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.dingwen.io.treasure.base.support.ICurrentUserService;
import top.dingwen.io.treasure.redis.annotation.ReSubmit;
import top.dingwen.io.treasure.redis.core.RedisServiceImpl;
import top.dingwen.io.treasure.redis.enums.RequestParam;
import top.dingwen.io.treasure.redis.exception.ReSubmitException;

@Aspect
public class ReSubmitAspect {
    private static final Logger log = LoggerFactory.getLogger(ReSubmitAspect.class);
    @Resource
    private RedisServiceImpl redisServiceImpl;
    @Resource
    private ICurrentUserService currentUserService;

    @Around(value="@annotation(reSubmit)")
    public Object doAround(ProceedingJoinPoint joinPoint, ReSubmit reSubmit) throws Throwable {
        String redisKey = this.generateRedisKey(reSubmit, joinPoint.getSourceLocation().getWithinType().getName(), joinPoint.getSignature().getName());
        long expire = this.redisServiceImpl.getExpire(redisKey);
        if (expire > 0L) {
            String message = StrUtil.format((CharSequence)"[redis]\u573a\u666f,[reSubmit],\u7528\u6237\uff1a{},\u9891\u7e41\u7684\u64cd\u4f5c\uff0c{}\u79d2\u540e\u518d\u8bd5,\u6d88\u606f:{}", (Object[])new Object[]{this.currentUserService.getUserId(), expire, reSubmit.message()});
            log.info(message);
            throw new ReSubmitException(message);
        }
        Boolean ifAbsent = this.redisServiceImpl.setIfAbsent(redisKey, "resubmit", reSubmit.time(), reSubmit.timeUnit());
        if (Boolean.FALSE.equals(ifAbsent)) {
            String message = StrUtil.format((CharSequence)"[redis]\u573a\u666f,[reSubmit],\u7528\u6237\uff1a{}\u9891\u7e41\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Object[])new Object[]{Convert.toStr((Object)this.currentUserService.getUserId())});
            log.info(message);
            throw new ReSubmitException(message);
        }
        Object result = joinPoint.proceed();
        this.isDeleteKeyHandler(reSubmit.isDeleteKey(), redisKey);
        return result;
    }

    private String generateRedisKey(ReSubmit annotation, String methodName, String className) {
        String key = annotation.key();
        String param = annotation.param();
        StringBuilder stringBuilder = new StringBuilder(key);
        if (annotation.isAppendUserId()) {
            stringBuilder.append(Convert.toStr((Object)this.currentUserService.getUserId()));
        }
        stringBuilder.append(methodName).append(":").append(className);
        if (StrUtil.isBlank((CharSequence)param)) {
            return stringBuilder.toString();
        }
        String paramString = this.getParamString(annotation.paramType(), param);
        if (StrUtil.isNotBlank((CharSequence)paramString)) {
            stringBuilder.append(":").append(paramString);
        }
        return stringBuilder.toString();
    }

    private String getParamString(RequestParam requestParam, String param) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        switch (requestParam) {
            case BODY: {
                return RequestParam.BODY.getCode();
            }
            case FORM: {
                return request.getParameter(param);
            }
            case HEADER: {
                return request.getHeader(param);
            }
        }
        return null;
    }

    private void isDeleteKeyHandler(boolean isDeleteKey, String key) {
        if (isDeleteKey) {
            this.redisServiceImpl.deleteObject(key);
        }
    }
}

