/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.autoconfigure;

import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import top.dingwen.io.treasure.base.util.thread.ThreadUtils;
import top.dingwen.io.treasure.redis.aspect.DelayRemovesAspect;
import top.dingwen.io.treasure.redis.aspect.EasyCacheAspect;
import top.dingwen.io.treasure.redis.aspect.RateLimiterAspect;
import top.dingwen.io.treasure.redis.aspect.ReSubmitAspect;
import top.dingwen.io.treasure.redis.autoconfigure.RedisProperties;
import top.dingwen.io.treasure.redis.core.DelayTaskComponent;
import top.dingwen.io.treasure.redis.core.RedisCacheInitComponent;
import top.dingwen.io.treasure.redis.core.RedisServiceImpl;
import top.dingwen.io.treasure.redis.core.RedisShareLockComponent;
import top.dingwen.io.treasure.redis.web.RedisIndexController;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RedisProperties.class})
@Lazy(value=false)
public class RedisAutoconfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisAutoconfiguration.class);
    @Resource
    private RedisProperties redisProperties;

    @PostConstruct
    public void init() {
        log.info("[redis]\u573a\u666f\u542f\u52a8\u5668\n\n               _ _     \n              | (_)    \n  _ __ ___  __| |_ ___ \n | '__/ _ \\/ _` | / __|\n | | |  __/ (_| | \\__ \\\n |_|  \\___|\\__,_|_|___/\n                       \n                       ");
        log.info("[redis]\u8bfb\u53d6\u5230\u7684redis\u76f8\u5173\u7684\u914d\u7f6e\u5982\u4e0b:\n{}", (Object)JSONUtil.toJsonPrettyStr((Object)this.redisProperties));
        log.info("[redis]\u573a\u666f\u542f\u52a8\u5668,\u542f\u52a8\u6210\u529f");
    }

    @Bean(value={"redisRedisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        jackson2JsonRedisSerializer.setObjectMapper(this.buildObjectMapper());
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    private ObjectMapper buildObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        mapper.registerModule((Module)javaTimeModule);
        mapper.setTimeZone(TimeZone.getDefault());
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.activateDefaultTyping(mapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL);
        return mapper;
    }

    @Bean
    public DefaultRedisScript<Long> limitScript() {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("limitScript.lua")));
        redisScript.setResultType(Long.class);
        return redisScript;
    }

    @Bean
    public DefaultRedisScript<Long> compareAndSetScript() {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptSource((ScriptSource)new ResourceScriptSource((org.springframework.core.io.Resource)new ClassPathResource("compareAndSet.lua")));
        redisScript.setResultType(Long.class);
        return redisScript;
    }

    @ConditionalOnProperty(name={"dingwen.treasure.redis.delayRemoves"}, havingValue="true")
    @Bean
    public ScheduledExecutorService scheduledExecutorService() {
        return new ScheduledThreadPoolExecutor(10, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("redis-delay-remove-schedule-pool-%d").daemon(true).build()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                ThreadUtils.printException((Runnable)r, (Throwable)t);
            }
        };
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.redis.delayRemoves"}, havingValue="true")
    public DelayRemovesAspect delayRemovesAspect() {
        return new DelayRemovesAspect();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.redis.easyCache"}, havingValue="true")
    public EasyCacheAspect easyCacheAspect() {
        return new EasyCacheAspect();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.redis.rateLimiter"}, havingValue="true")
    public RateLimiterAspect rateLimiterAspect() {
        return new RateLimiterAspect();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.redis.reSubmit"}, havingValue="true")
    public ReSubmitAspect reSubmitAspect() {
        return new ReSubmitAspect();
    }

    @Bean
    public RedisCacheInitComponent redisCacheInitComponent() {
        log.info("[redis][RedisCacheInitComponent]\u7f13\u5b58\u9884\u70ed\u7ec4\u4ef6\u5df2\u6210\u529f\u52a0\u8f7d");
        return new RedisCacheInitComponent();
    }

    @Bean
    public RedisShareLockComponent redisShareLockComponent() {
        log.info("[redis]][RedisShareLockComponent]\u5206\u5e03\u5f0f\u9501\u7ec4\u4ef6\u5df2\u6210\u529f\u52a0\u8f7d");
        return new RedisShareLockComponent();
    }

    @Bean
    public DelayTaskComponent delayTaskComponent() {
        log.info("[redis][DelayTaskComponent]\u5ef6\u8fdf\u4efb\u52a1\u7ec4\u4ef6\u5df2\u6210\u529f\u52a0\u8f7d");
        return new DelayTaskComponent();
    }

    @Bean
    public RedisServiceImpl redisService() {
        return new RedisServiceImpl();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.redis.defaultApiEnabled"}, havingValue="true")
    public RedisIndexController redisIndexController() {
        log.info("[redis][RedisIndexController]\u9ed8\u8ba4API\u5df2\u6210\u529f\u52a0\u8f7d");
        return new RedisIndexController();
    }
}

