/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.json.JSONUtil;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.base.util.date.DatePlusUtils;
import top.dingwen.io.treasure.redis.core.DelayTask;
import top.dingwen.io.treasure.redis.core.RedisServiceImpl;

public class DelayTaskComponent {
    private static final Logger log = LoggerFactory.getLogger(DelayTaskComponent.class);
    @Resource
    private RedisServiceImpl redisServiceImpl;

    public void push(DelayTask delayTask, String delayKey) {
        Date startTime = delayTask.getStartTime();
        String taskJson = JSONUtil.toJsonStr((Object)delayTask);
        if (Objects.isNull(startTime)) {
            log.warn("[Redis\u6a21\u5757]\t[\u5ef6\u8fdf\u4efb\u52a1\u7ec4\u4ef6],key:{},\u4efb\u52a1:{},\u5f00\u59cb\u65f6\u95f4\u7a7a\uff0c\u4efb\u52a1\u4e22\u5f03", (Object)delayKey, (Object)taskJson);
            return;
        }
        if (startTime.compareTo(DatePlusUtils.getNowDate()) <= 0) {
            log.warn("[Redis\u6a21\u5757]\t[\u5ef6\u8fdf\u4efb\u52a1\u7ec4\u4ef6],key:{},\u4efb\u52a1:{},\u5f00\u59cb\u4e0d\u662f\u672a\u6765\u7684\u65f6\u95f4\uff0c\u4efb\u52a1\u4e22\u5f03", (Object)delayKey, (Object)taskJson);
            return;
        }
        log.info("[Redis\u6a21\u5757]\t[\u5ef6\u8fdf\u4efb\u52a1\u7ec4\u4ef6],key:{},\u4efb\u52a1:{}\u5df2\u52a0\u5165\u5ef6\u8fdf\u961f\u5217", (Object)delayKey, (Object)JSONUtil.toJsonStr((Object)delayTask));
        this.redisServiceImpl.setZsetCacheValue(delayKey, taskJson, Convert.toDouble((Object)startTime.getTime()));
    }

    public Set<DelayTask> pull(String delayKey) {
        Double now = Convert.toDouble((Object)System.currentTimeMillis());
        Set<DelayTask> delayTasks = this.redisServiceImpl.getZsetCacheZet(delayKey, 0.0, now);
        log.info("[Redis\u6a21\u5757]\t[\u5ef6\u8fdf\u4efb\u52a1\u7ec4\u4ef6],key:{},\u83b7\u53d6\u5ef6\u8fdf\u4efb\u52a1ids:{}", (Object)delayKey, (Object)JSONUtil.toJsonStr(delayTasks));
        if (CollUtil.isEmpty(delayTasks)) {
            return Collections.emptySet();
        }
        this.redisServiceImpl.removeZset(delayKey, 0.0, now);
        return delayTasks;
    }
}

