/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Service;
import top.dingwen.io.treasure.base.util.str.StringPlusUtils;
import top.dingwen.io.treasure.redis.core.IRedisCacheService;

@Service
public class RedisServiceImpl
implements IRedisCacheService {
    @Resource(name="redisRedisTemplate")
    private RedisTemplate redisTemplate;

    @Override
    public <T> void setCacheObject(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public <T> void setCacheObject(String key, T value, Long timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout.longValue(), timeUnit);
    }

    @Override
    public boolean setExpire(String key, long timeout) {
        return this.setExpire(key, timeout, TimeUnit.SECONDS);
    }

    @Override
    public boolean setExpire(String key, long timeout, TimeUnit unit) {
        return Boolean.TRUE.equals(this.redisTemplate.expire((Object)key, timeout, unit));
    }

    @Override
    public long getExpire(String key) {
        if (Objects.isNull(this.redisTemplate) || StringPlusUtils.isBlank((CharSequence)key)) {
            return -1L;
        }
        return this.redisTemplate.getExpire((Object)key);
    }

    @Override
    public long getExpire(String key, TimeUnit timeUnit) {
        if (Objects.isNull(this.redisTemplate) || StringPlusUtils.isBlank((CharSequence)key)) {
            return -1L;
        }
        return this.redisTemplate.getExpire((Object)key, timeUnit);
    }

    @Override
    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public <T> T getCacheObject(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    @Override
    public <T> T getCacheObject(String key, Class<T> clazz) {
        return (T)JSONUtil.parseObj((String)((String)this.getCacheObject((T)key))).toBean(clazz);
    }

    public void deleteObject(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public long deleteObject(Collection collection) {
        if (Objects.isNull(this.redisTemplate) || CollUtil.isEmpty((Collection)collection)) {
            return -1L;
        }
        return (Long)ObjectUtil.defaultIfNull((Object)this.redisTemplate.delete(collection), (Object)-1L);
    }

    @Override
    public <T> long setCacheList(String key, List<T> dataList) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, dataList);
        return ObjectUtil.isEmpty((Object)count) ? 0L : count;
    }

    @Override
    public <T> List<T> getCacheList(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }

    @Override
    public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet) {
        BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
        for (T t : dataSet) {
            setOperation.add(new Object[]{t});
        }
        return setOperation;
    }

    @Override
    public <T> Set<T> getCacheSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (CollUtil.isNotEmpty(dataMap)) {
            this.redisTemplate.opsForHash().putAll((Object)key, dataMap);
        }
    }

    public <T> void setCacheMap(Map<String, T> dataMap) {
        if (CollUtil.isNotEmpty(dataMap)) {
            this.redisTemplate.opsForValue().multiSet(dataMap);
        }
    }

    @Override
    public <T> void removeCacheMap(Map<String, T> dataMap) {
        if (CollUtil.isNotEmpty(dataMap)) {
            dataMap.forEach((key, value) -> this.removeKeys((String)key));
        }
    }

    @Override
    public <T> boolean setZsetCacheValue(String key, T value, Double score) {
        if (Objects.isNull(this.redisTemplate) || StringPlusUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return this.redisTemplate.opsForZSet().add((Object)key, value, score.doubleValue());
    }

    @Override
    public <T> Set<T> getZsetCacheZet(String key, Double scoreStart, Double scoreEnd) {
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, scoreStart.doubleValue(), scoreEnd.doubleValue());
    }

    @Override
    public <T> void removeZset(String key, Set<T> values) {
        values.forEach(v -> this.redisTemplate.opsForZSet().remove((Object)key, new Object[]{v}));
    }

    public <T> Map<String, T> getCacheMap(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public <T> void setCacheMapValue(String key, String hKey, T value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hKey, value);
    }

    @Override
    public <T> void removeZset(String key, Double scoreStart, Double scoreEnd) {
        Set set = this.redisTemplate.opsForZSet().rangeByScore((Object)key, scoreStart.doubleValue(), scoreEnd.doubleValue());
        if (CollUtil.isEmpty((Collection)set)) {
            return;
        }
        this.redisTemplate.opsForZSet().remove((Object)key, set.toArray());
    }

    @Override
    public <T> T getCacheMapValue(String key, String hKey) {
        HashOperations opsForHash = this.redisTemplate.opsForHash();
        return (T)opsForHash.get((Object)key, (Object)hKey);
    }

    @Override
    public <T> List<T> getMultiCacheMapValue(String key, Collection<Object> hKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hKeys);
    }

    @Override
    public Collection<String> getKeys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    @Override
    public void removeKeys(String pattern) {
        if (Objects.isNull(this.redisTemplate) || StringPlusUtils.isBlank((CharSequence)pattern)) {
            return;
        }
        this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)pattern));
    }

    public <T> boolean setIfAbsent(String key, T value, Long timeout, TimeUnit timeUnit) {
        if (StringPlusUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value, timeout.longValue(), timeUnit);
    }

    @Override
    public <T> void convertAndSend(String channel, T message) {
        this.redisTemplate.convertAndSend(channel, message);
    }

    @Override
    public Long increment(String key, Integer step) {
        return this.redisTemplate.opsForValue().increment((Object)key, (long)step.intValue());
    }

    @Override
    public Long increment(String key) {
        return this.redisTemplate.opsForValue().increment((Object)key, 1L);
    }

    @Override
    public Long decrement(String key, Integer step) {
        return this.redisTemplate.opsForValue().decrement((Object)key, (long)step.intValue());
    }

    @Override
    public Long decrement(String key) {
        return this.redisTemplate.opsForValue().decrement((Object)key, 1L);
    }

    public void incrementForHashByKey(String hashKey, String key, Long step) {
        this.redisTemplate.opsForHash().increment((Object)hashKey, (Object)key, step.longValue());
    }

    @Override
    public <T> T execute(RedisScript<T> script, List<Object> keys, Object ... args) {
        return (T)this.redisTemplate.execute(script, keys, args);
    }

    @Override
    public Map<String, Object> getInfo() {
        Properties info = (Properties)this.redisTemplate.execute(RedisServerCommands::info);
        Properties commandStats = (Properties)this.redisTemplate.execute(connection -> connection.info("commandstats"));
        Object dbSize = this.redisTemplate.execute(RedisServerCommands::dbSize);
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("info", info);
        result.put("dbSize", dbSize);
        ArrayList pieList = new ArrayList();
        if (commandStats != null) {
            commandStats.stringPropertyNames().forEach(key -> {
                HashMap<String, String> data = new HashMap<String, String>(2);
                String property = commandStats.getProperty((String)key);
                data.put("name", StringPlusUtils.removeStart((String)key, (String)"cmdstat_"));
                data.put("value", StringPlusUtils.substringBetween((String)property, (String)"calls=", (String)",usec"));
                pieList.add(data);
            });
        }
        result.put("commandStats", pieList);
        return result;
    }

    public <T, V> void setCacheObject(T key, V val) {
        if (Objects.isNull(key)) {
            return;
        }
        this.setCacheObject(key, val);
    }

    public <T, V> V getCacheObject(T key) {
        if (Objects.isNull(key)) {
            return null;
        }
        return this.getCacheObject((T)Convert.toStr(key));
    }
}

