/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.core;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.redis.autoconfigure.RedisProperties;
import top.dingwen.io.treasure.redis.core.RedisServiceImpl;
import top.dingwen.io.treasure.redis.exception.ShareLockException;

public class RedisShareLockComponent {
    private static final Logger log = LoggerFactory.getLogger(RedisShareLockComponent.class);
    @Resource
    private RedisProperties redisProperties;
    @Resource
    private RedisServiceImpl redisServiceImpl;

    public boolean lock(String lockKey, String requestId, Long time, TimeUnit timeUnit) {
        this.lockParamsCheck(lockKey, requestId, time, timeUnit);
        long currentTime = System.currentTimeMillis();
        long outTime = currentTime + this.redisProperties.getShareLockTimeOut();
        boolean lockResult = false;
        while (currentTime < outTime) {
            lockResult = this.redisServiceImpl.setIfAbsent(lockKey, requestId, time, timeUnit);
            if (lockResult) {
                log.info("[Redis\u6a21\u5757]\t[\u5206\u5e03\u5f0f\u9501]\uff0c\u52a0\u9501\u6210\u529f\uff1alockKey:{},requestId:{},time:{},timeUnit:{}", new Object[]{lockKey, requestId, time, timeUnit});
                return true;
            }
            ThreadUtil.sleep((long)100L);
            currentTime = System.currentTimeMillis();
        }
        return lockResult;
    }

    private void lockParamsCheck(String lockKey, String requestId, Long time, TimeUnit timeUnit) {
        if (StrUtil.isBlank((CharSequence)lockKey) || StrUtil.isBlank((CharSequence)requestId) || time <= 0L || Objects.isNull((Object)timeUnit)) {
            log.error("[Redis\u6a21\u5757]\t[\u5206\u5e03\u5f0f\u9501]\uff0c\u52a0\u9501\u53c2\u6570\u9519\u8bef\uff1alockKey:{},requestId:{},time:{},timeUnit:{}", new Object[]{lockKey, requestId, time, timeUnit});
            throw new ShareLockException("\u52a0\u9501\u53c2\u6570\u5f02\u5e38");
        }
    }

    public boolean unLock(String lockKey, String requestId) {
        if (StrUtil.isBlank((CharSequence)lockKey) || StrUtil.isBlank((CharSequence)requestId)) {
            throw new ShareLockException("\u89e3\u9501\u53c2\u6570\u5f02\u5e38");
        }
        try {
            String cacheRequestId = (String)this.redisServiceImpl.getCacheObject(lockKey);
            if (requestId.equals(cacheRequestId)) {
                this.redisServiceImpl.deleteObject(lockKey);
                return true;
            }
        }
        catch (Exception e) {
            log.error("[Redis\u6a21\u5757]\t[\u5206\u5e03\u5f0f\u9501]\uff0c\u89e3\u9501\u5931\u8d25\u3002lockKey:{},requestId:{}", new Object[]{lockKey, requestId, e});
        }
        return false;
    }

    public boolean tryLock(String lockKey, String requestId, Long time, TimeUnit timeUnit) {
        this.lockParamsCheck(lockKey, requestId, time, timeUnit);
        return this.redisServiceImpl.setIfAbsent(lockKey, requestId, time, timeUnit);
    }
}

