/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.redis.web;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.dingwen.io.treasure.base.util.bean.BeanCopyUtils;
import top.dingwen.io.treasure.base.util.uuid.IdUtils;
import top.dingwen.io.treasure.redis.annotation.EasyCache;
import top.dingwen.io.treasure.redis.annotation.RateLimiter;
import top.dingwen.io.treasure.redis.annotation.ReSubmit;
import top.dingwen.io.treasure.redis.autoconfigure.RedisProperties;
import top.dingwen.io.treasure.redis.core.DelayTask;
import top.dingwen.io.treasure.redis.core.DelayTaskComponent;
import top.dingwen.io.treasure.redis.core.IRedisCacheService;
import top.dingwen.io.treasure.redis.core.RedisShareLockComponent;
import top.dingwen.io.treasure.redis.model.bo.CacheBO;
import top.dingwen.io.treasure.redis.model.vo.CacheVO;
import top.dingwen.io.treasure.redis.model.vo.EasyCacheSubmitVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.web.webplus.BaseViewController;

@RestController
@RequestMapping(value={"common/redis"})
public class RedisIndexController
implements BaseViewController {
    private static final Logger log = LoggerFactory.getLogger(RedisIndexController.class);
    @Resource
    private IRedisCacheService redisServiceImpl;
    @Resource
    private RedisProperties redisProperties;
    @Resource
    private RedisShareLockComponent redisShareLockComponent;
    @Resource
    private DelayTaskComponent delayTaskComponent;

    @GetMapping(value={"/info"})
    public ResultVO getInfo() {
        return this.success(this.redisServiceImpl.getInfo());
    }

    @GetMapping
    public ResultVO<List<CacheVO>> getCaches() {
        List<CacheBO> caches = this.redisProperties.getCaches();
        List cacheVOS = BeanCopyUtils.copyList(caches, CacheVO.class);
        return this.success(cacheVOS);
    }

    @GetMapping(value={"/{keyPrefix}"})
    public ResultVO<Collection<String>> getKeys(@PathVariable(value="keyPrefix") String keyPrefix) {
        return this.success(this.redisServiceImpl.getKeys(keyPrefix + "*"));
    }

    @GetMapping(value={"/{keyPrefix}/{key}"})
    public ResultVO<CacheVO> getCache(@PathVariable(value="keyPrefix") String keyPrefix, @PathVariable(value="key") String key) {
        String cacheValue = (String)this.redisServiceImpl.getCacheObject(key);
        CacheVO cacheVO = CacheVO.builder().keyPrefix(keyPrefix).cacheKey(key).cacheValue(cacheValue).build();
        return this.success(cacheVO);
    }

    @PutMapping(value={"/{keyPrefix}"})
    public ResultVO<String> cleanCaches(@PathVariable(value="keyPrefix") String keyPrefix) {
        this.redisServiceImpl.removeKeys(keyPrefix + "*");
        return this.success();
    }

    @DeleteMapping(value={"/{key}"})
    public ResultVO<String> cleanCache(@PathVariable(value="key") String key) {
        this.redisServiceImpl.deleteObject(key);
        return this.success();
    }

    @DeleteMapping
    public ResultVO<String> cleanAllCache() {
        this.redisServiceImpl.removeKeys("*");
        return this.success();
    }

    @PostMapping(value={"/test/easy-cache"})
    @EasyCache(keyParams={"#easyCacheSubmitVO.getId()", "#easyCacheSubmitVO.getName()"}, time=100L, returnType=ResultVO.class)
    public ResultVO<EasyCacheSubmitVO> easyCache(@RequestBody EasyCacheSubmitVO easyCacheSubmitVO) {
        return this.success(easyCacheSubmitVO);
    }

    @GetMapping(value={"/test/rate-limit"})
    @RateLimiter(time=1, count=2)
    public ResultVO<String> rateLimit() {
        return this.success();
    }

    @GetMapping(value={"/test/re-submit"})
    @ReSubmit(message="\u767b\u5f55\u91cd\u590d\u63d0\u4ea4\u8bf7\u6c42", isDeleteKey=false, time=90L)
    public void resubmit() {
        log.info("RedisController resubmit");
    }

    @GetMapping(value={"/test/lock"})
    public ResultVO<String> lock() {
        boolean ifAbsent = this.redisServiceImpl.setIfAbsent("common_lock:".concat("test"), "lock test", 1L, TimeUnit.MINUTES);
        long expire = this.redisServiceImpl.getExpire("common_lock:".concat("test"), TimeUnit.SECONDS);
        if (ObjectUtil.isNotNull((Object)ifAbsent) && ifAbsent) {
            return this.success();
        }
        String message = CharSequenceUtil.format((CharSequence)"\u9891\u7e41\u7684\u64cd\u4f5c\uff0c\u8bf7{}\u79d2\u540e\u91cd\u8bd5", (Object[])new Object[]{expire});
        return this.failure(message);
    }

    @PutMapping(value={"/test/push-delay-task"})
    public ResultVO<String> pushDelayTask(@RequestParam Long taskId) {
        DelayTask delayTask = DelayTask.builder().taskOrigin(taskId).startTime(new Date(System.currentTimeMillis() + 10L)).build();
        this.delayTaskComponent.push(delayTask, "treasure:redis:delayTask:test");
        return this.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/test/consume-delay-task"})
    public ResultVO<String> consumeTestDelayTask() {
        String lockKey = "treasure:redis:delayTask:test:lock";
        String delayTaskKey = "treasure:redis:delayTask:test";
        String requestId = IdUtils.fastUUID();
        try {
            boolean lock = this.redisShareLockComponent.lock(lockKey, requestId, 5L, TimeUnit.MINUTES);
            if (!lock) {
                ResultVO resultVO = this.failure("\u8d44\u6e90\u62a2\u5360\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5...");
                return resultVO;
            }
            Set<DelayTask> delayTasks = this.delayTaskComponent.pull(delayTaskKey);
            log.info("[Redis\u6a21\u5757]\t[\u6d88\u8d39\u6d4b\u8bd5\u5ef6\u8fdf\u4efb\u52a1]\uff0c\u62c9\u53d6\u5230\u5ef6\u8fdf\u4efb\u52a1:{}", (Object)JSONUtil.toJsonStr(delayTasks));
            if (CollUtil.isEmpty(delayTasks)) {
                ResultVO resultVO = this.failure("\u6682\u65f6\u6ca1\u6709\u5ef6\u8fdf\u4efb\u52a1\u9700\u8981\u6267\u884c\u54e6\uff5e");
                return resultVO;
            }
        }
        catch (Exception e) {
            log.info("[Redis\u6a21\u5757]\t[\u6d88\u8d39\u6d4b\u8bd5\u5ef6\u8fdf\u4efb\u52a1]\uff0c\u6267\u884c\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            ResultVO resultVO = this.failure("\u670d\u52a1\u5668\u5f00\u5c0f\u5dee\u4e86\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5...");
            return resultVO;
        }
        finally {
            this.redisShareLockComponent.unLock(lockKey, requestId);
        }
        return this.success();
    }
}

