/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.autoconfigure;

import cn.hutool.json.JSONUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import top.dingwen.io.treasure.base.util.spring.SpringUtils;
import top.dingwen.io.treasure.webplus.aspect.DebugLogAspect;
import top.dingwen.io.treasure.webplus.autoconfigure.WebPlusProperties;
import top.dingwen.io.web.webplus.WebPlusIndexController;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={WebPlusProperties.class})
@Lazy(value=false)
public class WebPlusAutoconfiguration {
    private static final Logger log = LoggerFactory.getLogger(WebPlusAutoconfiguration.class);

    @PostConstruct
    public void init() {
        log.info("[webplus]\u573a\u666f\u542f\u52a8\u5668\n\n               _           _           \n              | |         | |          \n __      _____| |__  _ __ | |_   _ ___ \n \\ \\ /\\ / / _ \\ '_ \\| '_ \\| | | | / __|\n  \\ V  V /  __/ |_) | |_) | | |_| \\__ \\\n   \\_/\\_/ \\___|_.__/| .__/|_|\\__,_|___/\n                    | |                \n                    |_|                ");
        String properties = JSONUtil.toJsonPrettyStr((Object)SpringUtils.getBean(WebPlusProperties.class));
        log.info("[webplus]\u573a\u666f\u542f\u52a8\u5668,\u8bfb\u53d6\u5230\u7684\u914d\u7f6e\u5982\u4e0b:{}", (Object)properties);
        log.info("[webplus]\u573a\u666f\u542f\u52a8\u5668,\u542f\u52a8\u6210\u529f");
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.webplus.debug"}, havingValue="true")
    public DebugLogAspect debugLogAspect() {
        return new DebugLogAspect();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.webplus.defaultApiEnabled"}, havingValue="true")
    public WebPlusIndexController webplusIndexController() {
        return new WebPlusIndexController();
    }
}

