/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.config;

import cn.hutool.core.util.StrUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class I18nConfig {
    private static final Logger log = LoggerFactory.getLogger(I18nConfig.class);
    private static final int LEGAL_LANGUAGE_HEADER_ARR_SIZE = 2;

    @Bean
    public LocaleResolver i18nLocaleResolver() {
        return new I18nLocaleResolver();
    }

    public static class I18nLocaleResolver
    implements LocaleResolver {
        public Locale resolveLocale(HttpServletRequest httpServletRequest) {
            String[] split;
            String language = httpServletRequest.getHeader("Content-Language");
            if (StrUtil.isNotBlank((CharSequence)language) && 2 == (split = language.split("_")).length) {
                return new Locale(split[0], split[1]);
            }
            return Locale.CHINA;
        }

        public void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
            log.info("[webplus] I18nConfig setLocale() \u6267\u884c");
        }
    }
}

