/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.config.web;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import top.dingwen.io.treasure.webplus.autoconfigure.WebPlusProperties;
import top.dingwen.io.treasure.webplus.model.bo.ResourceHandler;

@Configuration
public class WebPlusWebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebPlusWebMvcConfig.class);
    @Resource
    private WebPlusProperties webPlusProperties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        List<ResourceHandler> handlers = this.webPlusProperties.getHandlers();
        if (CollUtil.isNotEmpty(handlers)) {
            handlers.forEach(resourceHandler -> registry.addResourceHandler(new String[]{resourceHandler.getHandler()}).addResourceLocations(new String[]{resourceHandler.getLocations()}));
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        Map interceptors = SpringUtil.getBeansOfType(HandlerInterceptor.class);
        if (CollUtil.isEmpty((Map)interceptors)) {
            return;
        }
        for (Map.Entry entry : interceptors.entrySet()) {
            registry.addInterceptor((HandlerInterceptor)entry.getValue());
        }
    }
}

