/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.filter;

import cn.hutool.json.JSONUtil;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class GlobalLogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalLogFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        log.info("[webplus] >>> \u5f00\u59cb\u8bf7\u6c42");
        StopWatch stopWatch = new StopWatch();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String url = request.getRequestURL().toString();
        stopWatch.start(url);
        log.info("\u8bf7\u6c42\u5730\u5740: {}", (Object)url);
        String protocol = request.getProtocol();
        log.info("\u534f\u8bae\u7248\u672c: {}", (Object)protocol);
        String method = request.getMethod();
        log.info("\u8bf7\u6c42\u65b9\u5f0f:{}", (Object)method);
        log.info("\u8bf7\u6c42\u5934\u4fe1\u606f");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            log.info("\u8bf7\u6c42\u5934\u540d\u79f0:{},\u8bf7\u6c42\u5934\u503c:{}", (Object)headerNames, (Object)headerValue);
        }
        String queryString = request.getQueryString();
        log.info("\u67e5\u8be2\u5b57\u7b26\u4e32:{}", (Object)queryString);
        Map parameterMap = request.getParameterMap();
        log.info("\u8bf7\u6c42\u4f53\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)parameterMap));
        filterChain.doFilter(servletRequest, servletResponse);
        stopWatch.stop();
        log.info("[webplus] >>> \u7ed3\u675f\u8bf7\u6c42,\u8017\u65f6:{}", (Object)stopWatch.prettyPrint());
    }
}

