/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import top.dingwen.io.treasure.base.util.str.StringPlusUtils;
import top.dingwen.io.treasure.webplus.filter.XssHttpServletRequestWrapper;

public class XssFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XssFilter.class);
    private static final List<String> EXCLUDES = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        String tempExcludes = filterConfig.getInitParameter("excludes");
        if (StringPlusUtils.isNotEmpty((String)tempExcludes)) {
            String[] url = tempExcludes.split(",");
            Collections.addAll(EXCLUDES, url);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.handleExcludeURL(req)) {
            chain.doFilter(request, response);
            return;
        }
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
        chain.doFilter((ServletRequest)xssRequest, response);
    }

    private boolean handleExcludeURL(HttpServletRequest request) {
        String url = request.getServletPath();
        String method = request.getMethod();
        if (method == null || HttpMethod.GET.matches(method) || HttpMethod.DELETE.matches(method)) {
            return true;
        }
        return StringPlusUtils.matches((String)url, EXCLUDES);
    }

    public void destroy() {
        log.info("[webplus] XssFilter destroy()");
    }
}

