/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.model.vo;

import cn.hutool.core.convert.Convert;
import java.io.Serializable;
import java.util.List;
import top.dingwen.io.treasure.webplus.util.servlet.ServletUtils;

public class PageVO<T>
implements Serializable {
    private Integer pageSize;
    private Integer pageNum;
    private Long totalNum;
    private Integer totalPage;
    private List<T> rows;
    private static final long serialVersionUID = 8862296739326979676L;

    public static <T> PageVO from(Long totalNum, Integer pageSize, Integer pageNum, List<T> ts) {
        return PageVO.builder().pageNum(pageNum).pageSize(pageSize).totalPage(Convert.toInt((Object)Math.ceil(Convert.toDouble((Object)totalNum) / (double)pageSize.intValue()))).totalNum(totalNum).rows(ts).build();
    }

    public static <T> PageVO from(Long totalNum, List<T> ts) {
        Integer pageSize = Convert.toInt((Object)ServletUtils.getParameter("pageSize"), (Integer)10);
        Integer pageNum = Convert.toInt((Object)ServletUtils.getParameter("pageNum"), (Integer)1);
        return PageVO.builder().pageNum(pageNum).pageSize(pageSize).totalPage(Convert.toInt((Object)Math.ceil(Convert.toDouble((Object)totalNum) / (double)pageSize.intValue()))).totalNum(totalNum).rows(ts).build();
    }

    public static <T> PageVOBuilder<T> builder() {
        return new PageVOBuilder();
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Long getTotalNum() {
        return this.totalNum;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public void setTotalNum(Long totalNum) {
        this.totalNum = totalNum;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageVO)) {
            return false;
        }
        PageVO other = (PageVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Long this$totalNum = this.getTotalNum();
        Long other$totalNum = other.getTotalNum();
        if (this$totalNum == null ? other$totalNum != null : !((Object)this$totalNum).equals(other$totalNum)) {
            return false;
        }
        Integer this$totalPage = this.getTotalPage();
        Integer other$totalPage = other.getTotalPage();
        if (this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage)) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Long $totalNum = this.getTotalNum();
        result = result * 59 + ($totalNum == null ? 43 : ((Object)$totalNum).hashCode());
        Integer $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    public String toString() {
        return "PageVO(pageSize=" + this.getPageSize() + ", pageNum=" + this.getPageNum() + ", totalNum=" + this.getTotalNum() + ", totalPage=" + this.getTotalPage() + ", rows=" + this.getRows() + ")";
    }

    public PageVO(Integer pageSize, Integer pageNum, Long totalNum, Integer totalPage, List<T> rows) {
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.totalNum = totalNum;
        this.totalPage = totalPage;
        this.rows = rows;
    }

    public PageVO() {
    }

    public static class PageVOBuilder<T> {
        private Integer pageSize;
        private Integer pageNum;
        private Long totalNum;
        private Integer totalPage;
        private List<T> rows;

        PageVOBuilder() {
        }

        public PageVOBuilder<T> pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PageVOBuilder<T> pageNum(Integer pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public PageVOBuilder<T> totalNum(Long totalNum) {
            this.totalNum = totalNum;
            return this;
        }

        public PageVOBuilder<T> totalPage(Integer totalPage) {
            this.totalPage = totalPage;
            return this;
        }

        public PageVOBuilder<T> rows(List<T> rows) {
            this.rows = rows;
            return this;
        }

        public PageVO<T> build() {
            return new PageVO<T>(this.pageSize, this.pageNum, this.totalNum, this.totalPage, this.rows);
        }

        public String toString() {
            return "PageVO.PageVOBuilder(pageSize=" + this.pageSize + ", pageNum=" + this.pageNum + ", totalNum=" + this.totalNum + ", totalPage=" + this.totalPage + ", rows=" + this.rows + ")";
        }
    }
}

