/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.model.vo;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.spring.SpringUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.util.ObjectUtils;
import top.dingwen.io.treasure.webplus.model.vo.PageVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.util.message.MessageUtils;

public final class ResultVOGenerator {
    public static <T> ResultVO<T> genDefaultResult() {
        return ResultVO.builder().code(204).build();
    }

    public static <T> ResultVO<T> genInternationalDefaultResult(String key, Object ... params) {
        return ResultVOGenerator.genInternationalSuccessResultOnlyMessage(key, params);
    }

    public static <T> ResultVO<T> genSuccessResult() {
        return ResultVO.builder().build();
    }

    public static <T> ResultVO<T> genInternationalSuccessResult() {
        return ResultVOGenerator.genInternationalSuccessResultOnlyMessage("treasure.success", new Object[0]);
    }

    public static <T> ResultVO<T> genSuccessResultOnlyMessage(String message) {
        return ResultVO.builder().message(message).build();
    }

    public static <T> ResultVO<T> genInternationalSuccessResultOnlyMessage(String key, Object ... params) {
        String message = MessageUtils.message(key, params);
        return ResultVOGenerator.genSuccessResultOnlyMessage(message);
    }

    public static <T> ResultVO<T> genSuccessResult(T data) {
        return ResultVO.builder().data(data).code(ObjectUtils.isEmpty(data) ? 204 : 200).build();
    }

    public static <T> ResultVO<T> genSuccessResult(T data, Integer code) {
        return ResultVO.builder().data(data).code(code).build();
    }

    public static <T> ResultVO<T> genSuccessResult(Integer code) {
        return ResultVO.builder().code(code).build();
    }

    public static <T> ResultVO<T> genSuccessResult(T data, String message) {
        return ResultVO.builder().data(data).code(ObjectUtils.isEmpty(data) ? 204 : 200).message(message).build();
    }

    public static <T> ResultVO<T> genInternationalSuccessResult(T data, String key, Object ... params) {
        String message = MessageUtils.message(key, params);
        return ResultVOGenerator.genSuccessResult(data, message);
    }

    public static <T> ResultVO<T> genFailureResultOnlyMessage(String message) {
        return ResultVO.builder().message(message).code(500).build();
    }

    public static <T> ResultVO<T> genFailureResultOnlyMessage(String message, Integer code) {
        return ResultVO.builder().message(message).code(code).build();
    }

    public static <T> ResultVO<T> genInternationalFailureResultOnlyMessage(String key, Object ... params) {
        if ("prod".equals(SpringUtil.getActiveProfile())) {
            key = key.concat(".friendly");
        }
        String message = MessageUtils.message(key, params);
        return ResultVOGenerator.genFailureResultOnlyMessage(message);
    }

    public static <T> ResultVO<T> genInternationalFailureResultMessageAndCode(String key, Integer code, Object ... params) {
        if ("prod".equals(SpringUtil.getActiveProfile())) {
            key = key.concat(".friendly");
        }
        String message = MessageUtils.message(key, params);
        return ResultVOGenerator.genFailureResultOnlyMessage(message, code);
    }

    public static <T> ResultVO<T> genInternationalFailureResultMessageAndCodeAndModule(String module, String key, Integer code, String ... params) {
        if ("prod".equals(SpringUtil.getActiveProfile())) {
            key = key.concat(".friendly");
        }
        String message = MessageUtils.message(key, new Object[]{params});
        return ResultVOGenerator.genFailureResultOnlyMessage(CharSequenceUtil.format((CharSequence)"[{}]:{}", (Object[])new Object[]{module, message}), code);
    }

    public static <T> ResultVO<T> genFailureResult() {
        return ResultVO.builder().message("FAIL").code(500).build();
    }

    public static <T> ResultVO<T> genInternationalFailureResult() {
        return ResultVOGenerator.genInternationalFailureResultOnlyStatus("treasure.fail", 500, new Object[0]);
    }

    public static <T> ResultVO<T> genFailureResult(String message, Integer httpStatus) {
        return ResultVO.builder().message(message).code(httpStatus).build();
    }

    public static <T> ResultVO<T> genInternationalFailureResultOnlyStatus(String key, Integer httpStatus, Object ... params) {
        String message = MessageUtils.message(key, params);
        return ResultVOGenerator.genFailureResult(message, httpStatus);
    }

    public static <T> ResultVO<T> genInternationalFailureResult(String key, T t, Object ... params) {
        String message = MessageUtils.message(key, params);
        return ResultVOGenerator.genFailureResult(message, t);
    }

    public static <T> ResultVO<T> genFailureResult(String message, T t) {
        return ResultVO.builder().message(message).data(t).build();
    }

    public static <T> ResultVO<T> genFailureResult(String message, Integer httpStatus, T t) {
        return ResultVO.builder().message(message).code(httpStatus).data(t).build();
    }

    public static <T> ResultVO<T> genInternationalFailureResult(String key, Integer httpStatus, T t, Object ... params) {
        String message = MessageUtils.message(key, params);
        return ResultVOGenerator.genFailureResult(message, httpStatus, t);
    }

    public static <T> ResultVO<T> genResult(boolean resultFlag) {
        return resultFlag ? ResultVOGenerator.genSuccessResult() : ResultVOGenerator.genFailureResult();
    }

    public static <T> ResultVO<T> genResult(Integer row) {
        return row > 0 ? ResultVOGenerator.genSuccessResult() : ResultVOGenerator.genFailureResult();
    }

    public static <T> ResultVO<PageVO<T>> genPageResult(List<T> ts, Long totalNum) {
        PageVO<T> pageVo = ResultVOGenerator.buildPageVO(totalNum, ts);
        return ResultVOGenerator.genSuccessResult(pageVo);
    }

    public static <T, R> PageVO<R> genPageResult(Long totalNum, List<T> ts, Function<List<T>, List<R>> func) {
        if (Objects.isNull(func)) {
            func = re -> ts;
        }
        return ResultVOGenerator.buildAndConvertPageVO(totalNum, func.apply(ts));
    }

    public static <T> PageVO<T> genPageResult(Long totalNum, Integer pageSize, Integer pageNum, List<T> ts) {
        return ResultVOGenerator.buildPageVO(totalNum, pageSize, pageNum, ts);
    }

    public static <R> PageVO<R> buildPageVO(Long totalNum, Integer pageSize, Integer pageNum, List<R> rs) {
        return PageVO.from(totalNum, pageSize, pageNum, rs);
    }

    public static <R> PageVO<R> buildPageVO(Long totalNum, List<R> rs) {
        return PageVO.from(totalNum, rs);
    }

    public static <R> PageVO<R> buildAndConvertPageVO(Long totalNum, List<R> rs) {
        return PageVO.from(totalNum, rs);
    }

    public static <R> ResultVO<R> genInternationalUnauthorizedResult(R data) {
        return ResultVO.builder().code(401).message(MessageUtils.message("treasure.webplus.unauthorized", new Object[0])).data(data).build();
    }

    public static <R> ResultVO<R> genInternationalLoginResult(R data) {
        return ResultVO.builder().code(401).message(MessageUtils.message("treasure.webplus.login", new Object[0])).data(data).build();
    }

    public static <R> ResultVO<R> genInternationalAuthorizedResult(R data) {
        return ResultVO.builder().code(200).message(MessageUtils.message("treasure.webplus.authorized", new Object[0])).data(data).build();
    }

    public static <R> ResultVO<R> genInternationalLogoutResult(R data) {
        return ResultVO.builder().code(200).message(MessageUtils.message("treasure.webplus.logout", new Object[0])).data(data).build();
    }

    public static <R> ResultVO<R> genInternationalForbiddenResult(R data) {
        return ResultVO.builder().code(403).message(MessageUtils.message("treasure.webplus.forbidden", new Object[0])).data(data).build();
    }

    private ResultVOGenerator() {
    }
}

