/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.util.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import top.dingwen.io.treasure.base.core.func.Predicate;
import top.dingwen.io.treasure.base.core.func.SFunction;
import top.dingwen.io.treasure.webplus.util.checker.CheckerException;
import top.dingwen.io.treasure.webplus.util.checker.Condition;
import top.dingwen.io.treasure.webplus.util.checker.ConvertUtils;
import top.dingwen.io.treasure.webplus.util.checker.ECheckType;
import top.dingwen.io.treasure.webplus.util.checker.handler.ConditionHandler;
import top.dingwen.io.treasure.webplus.util.checker.handler.HandleFunction;

public class Checker<T> {
    private final List<Condition<T>> conditions = new ArrayList<Condition<T>>();
    private static final Map<ECheckType, HandleFunction> FUNCTION_HASH_MAP = new HashMap<ECheckType, HandleFunction>();

    public Checker<T> ne(SFunction<T, ?> column, Object val, String desc) {
        this.conditions.add(new Condition(this.getFieldMeta(column), ECheckType.NE, val, desc));
        return this;
    }

    public Checker<T> notNull(SFunction<T, ?> column, String desc) {
        this.conditions.add(new Condition(this.getFieldMeta(column), ECheckType.NOTNULL, null, desc));
        return this;
    }

    public Checker<T> notNe(SFunction<T, ?> column, Object val, String desc) {
        this.conditions.add(new Condition(this.getFieldMeta(column), ECheckType.NOTNULL_NE, val, desc));
        return this;
    }

    public Checker<T> in(SFunction<T, ?> column, Collection<Object> val, String desc) {
        this.conditions.add(new Condition(this.getFieldMeta(column), ECheckType.IN, val, desc));
        return this;
    }

    public Checker<T> ne(SFunction<T, ?> column, Object val) {
        return this.ne(column, val, null);
    }

    public Checker<T> notNull(SFunction<T, ?> column) {
        return this.notNull(column, null);
    }

    public Checker<T> notBlank(SFunction<T, ?> column, String desc) {
        this.conditions.add(new Condition(this.getFieldMeta(column), ECheckType.NOT_BLANK, null, desc));
        return this;
    }

    public Checker<T> notNe(SFunction<T, ?> column, Object val) {
        return this.notNe(column, val, null);
    }

    public Checker<T> in(SFunction<T, ?> column, Collection<Object> val) {
        return this.in(column, val, null);
    }

    public Checker<T> custom(Predicate<T> resultPredicate, String desc) {
        Condition<T> condition = new Condition<T>("", ECheckType.CUSTOM, null, desc);
        condition.setResultPredicate(resultPredicate);
        this.conditions.add(condition);
        return this;
    }

    public void check(T obj) {
        if (Objects.isNull(obj)) {
            throw new CheckerException(new String[]{"\u53c2\u6570\u4e3a\u7a7a"});
        }
        for (Condition<T> condition : this.conditions) {
            FUNCTION_HASH_MAP.get((Object)condition.getType()).apply(obj, condition);
        }
    }

    private String getFieldMeta(SFunction<T, ?> column) {
        return ConvertUtils.convertToFieldName(column);
    }

    static {
        FUNCTION_HASH_MAP.put(ECheckType.NE, ConditionHandler::handleNe);
        FUNCTION_HASH_MAP.put(ECheckType.NOTNULL, ConditionHandler::handleNotNull);
        FUNCTION_HASH_MAP.put(ECheckType.NOTNULL_NE, ConditionHandler::handleNotNullNe);
        FUNCTION_HASH_MAP.put(ECheckType.IN, ConditionHandler::handleIn);
        FUNCTION_HASH_MAP.put(ECheckType.CUSTOM, ConditionHandler::handleCustom);
        FUNCTION_HASH_MAP.put(ECheckType.NOT_BLANK, ConditionHandler::handleNotBlank);
    }
}

