/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.util.checker;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import top.dingwen.io.treasure.base.core.func.SFunction;

public class ConvertUtils {
    public static final String GET = "get";
    public static final String IS = "is";
    private static final Map<Class<?>, String> CLASS_FIELD_META_MAP = new ConcurrentHashMap();

    private ConvertUtils() {
    }

    public static <T> String convertToFieldName(SFunction<T, ?> fn) {
        SerializedLambda lambda = ConvertUtils.getSerializedLambda(fn);
        String cacheData = CLASS_FIELD_META_MAP.get(fn.getClass());
        if (Objects.nonNull(cacheData)) {
            return cacheData;
        }
        String methodName = lambda.getImplMethodName();
        if (methodName.startsWith(GET)) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith(IS)) {
            methodName = methodName.substring(2);
        } else {
            throw new IllegalArgumentException("\u65e0\u6548\u7684getter\u65b9\u6cd5\uff1a" + methodName);
        }
        String fieldMeta = ConvertUtils.firstToLowerCase(methodName);
        CLASS_FIELD_META_MAP.put(fn.getClass(), fieldMeta);
        return fieldMeta;
    }

    public static SerializedLambda getSerializedLambda(Serializable fn) {
        Method method = fn.getClass().getMethod("writeReplace", new Class[0]);
        return (SerializedLambda)method.invoke((Object)fn, new Object[0]);
    }

    public static String firstToLowerCase(String str) {
        if (null == str || str.isEmpty()) {
            return "";
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }
}

