/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.util.message;

import cn.hutool.extra.spring.SpringUtil;
import java.util.Locale;
import java.util.Objects;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import top.dingwen.io.treasure.base.util.spring.SpringUtils;
import top.dingwen.io.treasure.webplus.config.I18nConfig;
import top.dingwen.io.treasure.webplus.util.servlet.ServletUtils;

public final class MessageUtils {
    public static String message(String key, Object ... args) {
        MessageSource messageSource = (MessageSource)SpringUtil.getBean(MessageSource.class);
        if (Objects.isNull(messageSource)) {
            return "";
        }
        I18nConfig.I18nLocaleResolver i18nLocaleResolver = (I18nConfig.I18nLocaleResolver)SpringUtils.getBean(I18nConfig.I18nLocaleResolver.class);
        if (Objects.nonNull(i18nLocaleResolver)) {
            LocaleContextHolder.setLocale((Locale)i18nLocaleResolver.resolveLocale(ServletUtils.getRequest()));
        }
        return messageSource.getMessage(key, args, LocaleContextHolder.getLocale());
    }

    private MessageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

