/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.util.servlet;

import cn.hutool.core.convert.Convert;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.ContentType;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils
extends ServletUtil {
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);

    public static String getParameter(String name) {
        return ServletUtils.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return Convert.toStr((Object)ServletUtils.getRequest().getParameter(name), (String)defaultValue);
    }

    public static Integer getParameterToInt(String name) {
        return Convert.toInt((Object)ServletUtils.getRequest().getParameter(name));
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        return Convert.toInt((Object)ServletUtils.getRequest().getParameter(name), (Integer)defaultValue);
    }

    public static Boolean getParameterToBool(String name) {
        return Convert.toBool((Object)ServletUtils.getRequest().getParameter(name));
    }

    public static Boolean getParameterToBool(String name, Boolean defaultValue) {
        return Convert.toBool((Object)ServletUtils.getRequest().getParameter(name), (Boolean)defaultValue);
    }

    public static HttpServletRequest getRequest() {
        return ServletUtils.getRequestAttributes().getRequest();
    }

    public static String getParameters() {
        return JSONUtil.toJsonPrettyStr((Object)ServletUtil.getParams((ServletRequest)ServletUtils.getRequest()));
    }

    public static HttpServletResponse getResponse() {
        return ServletUtils.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static void renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType(ContentType.JSON.getValue());
            response.setCharacterEncoding("UTF-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            log.error("\u5c06\u5b57\u7b26\u4e32\u6e32\u67d3\u5230\u5ba2\u6237\u7aef\u65b9\u5f0f\u6267\u884c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static Map<String, String> getAllHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(16);
        Enumeration headerNames = ServletUtils.getRequest().getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, ServletUtils.getRequest().getHeader(headerName));
        }
        return headers;
    }

    public static String getClientIP() {
        return ServletUtils.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
    }

    public static String getServerUrl() {
        HttpServletRequest request = ServletUtils.getRequest();
        StringBuffer url = request.getRequestURL();
        String contextPath = request.getServletContext().getContextPath();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).append(contextPath).toString();
    }
}

