/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.web.webplus;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import top.dingwen.io.treasure.webplus.model.vo.PageVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVOGenerator;
import top.dingwen.io.treasure.webplus.util.servlet.ServletUtils;

public interface BaseViewController {
    @InitBinder
    default public void initBinder(WebDataBinder webDataBinder) {
        webDataBinder.registerCustomEditor(LocalDateTime.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(LocalDateTimeUtil.parseDate((CharSequence)text));
            }
        });
    }

    default public String redirect(String url) {
        return StrUtil.format((CharSequence)"redirect:{}", (Object[])new Object[]{url});
    }

    default public <T> ResultVO<T> success() {
        return ResultVOGenerator.genSuccessResult();
    }

    default public <T> ResultVO<T> internationalSuccess() {
        return ResultVOGenerator.genInternationalSuccessResult();
    }

    default public <T> ResultVO<T> success(String message) {
        return ResultVOGenerator.genSuccessResultOnlyMessage(message);
    }

    default public <T> ResultVO<T> success(String key, Object ... params) {
        return ResultVOGenerator.genInternationalSuccessResultOnlyMessage(key, params);
    }

    default public ResultVO<String> success(String data, boolean strData) {
        return strData ? ResultVOGenerator.genSuccessResult(data) : this.success((Object)data);
    }

    default public <T> ResultVO<T> success(T data) {
        return ResultVOGenerator.genSuccessResult(data);
    }

    default public <T> ResultVO<T> success(T data, Integer code) {
        if (Objects.isNull(data)) {
            return ResultVOGenerator.genSuccessResult(code);
        }
        return ResultVOGenerator.genSuccessResult(data, code);
    }

    default public <T> ResultVO<T> success(T data, String message) {
        return ResultVOGenerator.genSuccessResult(data, message);
    }

    default public <T> ResultVO<T> success(T data, String key, Object ... params) {
        return ResultVOGenerator.genInternationalSuccessResult(data, key, params);
    }

    default public <T> ResultVO<T> genResult(Integer row) {
        return ResultVOGenerator.genResult(row);
    }

    default public <T> ResultVO<T> genResult(boolean resultFlag) {
        return ResultVOGenerator.genResult(resultFlag);
    }

    default public <T> ResultVO<T> failure(String message) {
        return ResultVOGenerator.genFailureResultOnlyMessage(message);
    }

    default public <T> ResultVO<T> failure(String key, Object ... params) {
        return ResultVOGenerator.genInternationalFailureResultOnlyMessage(key, params);
    }

    default public <T> ResultVO<T> failure() {
        return ResultVOGenerator.genSuccessResult();
    }

    default public <T> ResultVO<T> failure(String message, Integer httpStatus) {
        return ResultVOGenerator.genFailureResult(message, httpStatus);
    }

    default public <T> ResultVO<T> failure(String key, Integer httpStatus, Object ... params) {
        return ResultVOGenerator.genInternationalFailureResultOnlyStatus(key, httpStatus, params);
    }

    default public <T> ResultVO<T> failure(String message, T t) {
        return ResultVOGenerator.genFailureResult(message, t);
    }

    default public <T> ResultVO<T> failure(String key, T t, Object ... params) {
        return ResultVOGenerator.genInternationalFailureResult(key, t, params);
    }

    default public <T> ResultVO<T> failure(String message, Integer httpStatus, T t) {
        return ResultVOGenerator.genFailureResult(message, httpStatus, t);
    }

    default public <T> ResultVO<T> failure(String key, Integer httpStatus, T t, Object ... params) {
        return ResultVOGenerator.genInternationalFailureResult(key, httpStatus, t, params);
    }

    default public <T> ResultVO<PageVO<T>> page(List<T> rows, Long total) {
        return ResultVOGenerator.genPageResult(rows, total);
    }

    default public void addContentDisposition(String fileName) {
        ServletUtils.getResponse().setHeader("Content-Disposition", CharSequenceUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8)}));
    }
}

