/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.aspect;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.dingwen.io.treasure.webplus.annotation.DebugLog;

@Aspect
public class DebugLogAspect {
    private static final Logger log = LoggerFactory.getLogger(DebugLogAspect.class);
    ThreadLocal<Long> startTime = new ThreadLocal();

    @Around(value="@annotation(debugLog)")
    public Object debugLog(ProceedingJoinPoint pjp, DebugLog debugLog) throws Throwable {
        log.info("{},{},\u5f00\u59cb\u8bb0\u5f55", (Object)"[webplus]\u573a\u666f\u542f\u52a8\u5668", (Object)"[DebugLogAspect]\u65b9\u6cd5debug\u65e5\u5fd7\u7ec4\u4ef6");
        this.startTime.set(System.currentTimeMillis());
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (attributes != null);
        HttpServletRequest request = attributes.getRequest();
        String className = pjp.getSignature().getDeclaringTypeName();
        String methodName = pjp.getSignature().getName();
        Object[] array = pjp.getArgs();
        ObjectMapper mapper = new ObjectMapper();
        log.info("\u8c03\u7528\u524d\uff1a{}\uff1a{},\u4f20\u9012\u7684\u53c2\u6570\u4e3a\uff1a{}", new Object[]{className, methodName, mapper.writeValueAsString((Object)array)});
        log.info("URL:{}", (Object)request.getRequestURL().toString());
        log.info("IP\u5730\u5740\uff1a{}", (Object)request.getRemoteAddr());
        Object obj = pjp.proceed();
        log.info("\u8c03\u7528\u540e\uff1a{}\uff1a{},\u8fd4\u56de\u503c\u4e3a\uff1a{}", new Object[]{className, methodName, mapper.writeValueAsString(obj)});
        log.info("\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - this.startTime.get()));
        this.startTime.remove();
        log.info("{},{}\u8bb0\u5f55\u7ed3\u675f", (Object)"[webplus]\u573a\u666f\u542f\u52a8\u5668", (Object)"[DebugLogAspect]\u65b9\u6cd5debug\u65e5\u5fd7\u7ec4\u4ef6");
        return obj;
    }
}

