/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.autoconfigure;

import cn.hutool.json.JSONUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.LocaleResolver;
import top.dingwen.io.treasure.base.util.spring.SpringUtils;
import top.dingwen.io.treasure.webplus.aspect.DebugLogAspect;
import top.dingwen.io.treasure.webplus.autoconfigure.WebPlusProperties;
import top.dingwen.io.treasure.webplus.config.MapStructPlusConfig;
import top.dingwen.io.treasure.webplus.config.ValidateConfig;
import top.dingwen.io.treasure.webplus.config.filter.WebplusFilterConfig;
import top.dingwen.io.treasure.webplus.config.sede.SeDeConfig;
import top.dingwen.io.treasure.webplus.config.web.WebPlusWebMvcConfig;
import top.dingwen.io.treasure.webplus.core.advice.TrimmedRequestBodyAdvice;
import top.dingwen.io.treasure.webplus.core.resolver.I18nLocaleResolver;
import top.dingwen.io.treasure.webplus.core.resolver.TrimmedReqArgumentResolver;
import top.dingwen.io.treasure.webplus.exception.DefaultGlobalExceptionMsgSender;
import top.dingwen.io.treasure.webplus.exception.GlobalExceptionHandler;
import top.dingwen.io.treasure.webplus.web.controller.WebPlusIndexController;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={WebPlusProperties.class})
@Lazy(value=false)
@Import(value={MapStructPlusConfig.class, WebplusFilterConfig.class, SeDeConfig.class, WebPlusWebMvcConfig.class, GlobalExceptionHandler.class, ValidateConfig.class, DefaultGlobalExceptionMsgSender.class})
public class WebPlusAutoconfiguration {
    private static final Logger log = LoggerFactory.getLogger(WebPlusAutoconfiguration.class);

    @PostConstruct
    public void init() {
        log.info("[webplus]\u573a\u666f\u542f\u52a8\u5668\n\n               _           _           \n              | |         | |          \n __      _____| |__  _ __ | |_   _ ___ \n \\ \\ /\\ / / _ \\ '_ \\| '_ \\| | | | / __|\n  \\ V  V /  __/ |_) | |_) | | |_| \\__ \\\n   \\_/\\_/ \\___|_.__/| .__/|_|\\__,_|___/\n                    | |                \n                    |_|                ");
        String properties = JSONUtil.toJsonPrettyStr((Object)SpringUtils.getBean(WebPlusProperties.class));
        log.info("{},\u8bfb\u53d6\u5230\u7684\u914d\u7f6e\u5982\u4e0b:\n{}", (Object)"[webplus]\u573a\u666f\u542f\u52a8\u5668", (Object)properties);
        String debugProperty = SpringUtils.getProperty((String)"dingwen.treasure.webplus.debug");
        log.info("{},\u65b9\u6cd5\u7ea7\u522b\u7684\u65e5\u5fd7\u914d\u7f6e:\n{}", (Object)"[webplus]\u573a\u666f\u542f\u52a8\u5668", (Object)debugProperty);
        log.info("{},\u542f\u52a8\u6210\u529f", (Object)"[webplus]\u573a\u666f\u542f\u52a8\u5668");
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.webplus.debug"}, havingValue="true")
    public DebugLogAspect debugLogAspect() {
        return new DebugLogAspect();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.webplus.defaultApiEnabled"}, havingValue="true")
    public WebPlusIndexController webplusIndexController() {
        return new WebPlusIndexController();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.webplus.globalTrimStringsEnabled"}, havingValue="true")
    public TrimmedReqArgumentResolver trimmedReqArgumentResolver() {
        return new TrimmedReqArgumentResolver();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.webplus.globalTrimStringsEnabled"}, havingValue="true")
    public TrimmedRequestBodyAdvice trimmedRequestBodyAdvice() {
        return new TrimmedRequestBodyAdvice();
    }

    @Bean
    public LocaleResolver i18nLocaleResolver() {
        return new I18nLocaleResolver();
    }

    @Bean
    public MessageSource webPlusMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"i18n/webplus_messages"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }
}

