/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.config;

import java.util.Properties;
import javax.annotation.Resource;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import top.dingwen.io.treasure.webplus.core.interceptor.WebPLusLocaleChangeInterceptor;

@Configuration
public class ValidateConfig
implements WebMvcConfigurer {
    @Resource
    private ResourceBundleMessageSource resourceBundleMessageSource;

    @Bean
    public Validator validator() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        MessageInterpolatorFactory interpolatorFactory = new MessageInterpolatorFactory();
        factoryBean.setMessageInterpolator(interpolatorFactory.getObject());
        factoryBean.setValidationMessageSource((MessageSource)this.resourceBundleMessageSource);
        factoryBean.setProviderClass(HibernateValidator.class);
        Properties properties = new Properties();
        properties.setProperty("hibernate.validator.fail_fast", "true");
        factoryBean.setValidationProperties(properties);
        factoryBean.afterPropertiesSet();
        return factoryBean.getValidator();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new WebPLusLocaleChangeInterceptor());
    }
}

