/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.core.advice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;
import top.dingwen.io.treasure.webplus.annotation.Trim;

@ControllerAdvice
public class TrimmedRequestBodyAdvice
extends RequestBodyAdviceAdapter {
    private static final Logger log = LoggerFactory.getLogger(TrimmedRequestBodyAdvice.class);

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return methodParameter.hasParameterAnnotation(Trim.class);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        log.info("{},{},\u6267\u884c\u8bf7\u6c42\u4f53\u53c2\u6570\u53bb\u9664\u7a7a\u683c", (Object)"[webplus]\u573a\u666f\u542f\u52a8\u5668", (Object)"[TrimmedRequestBodyAdvice]\u53bb\u9664\u8bf7\u6c42\u4f53\u7a7a\u683c\u9002\u914d\u5668");
        this.trimStrings(body);
        return body;
    }

    private void trimStrings(Object obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        if (obj instanceof String) {
            Trim trim = obj.getClass().getAnnotation(Trim.class);
            if (Objects.isNull(trim)) {
                return;
            }
            String name = obj.getClass().getName();
            obj = trim.value() ? this.replaceAll(obj, name, name) : this.trim(obj, name, name);
        } else if (obj instanceof Collection) {
            for (Object element : (Collection)obj) {
                this.trimStrings(element);
            }
        } else if (obj instanceof Map) {
            for (Object key : ((Map)obj).keySet()) {
                this.trimStrings(((Map)obj).get(key));
            }
        } else {
            for (Field field : ReflectUtil.getFields(obj.getClass())) {
                field.setAccessible(true);
                try {
                    Trim trim = field.getAnnotation(Trim.class);
                    if (Objects.isNull(trim)) continue;
                    Object value = field.get(obj);
                    if (value instanceof String) {
                        String className = obj.getClass().getSimpleName();
                        ReflectUtil.setFieldValue((Object)obj, (Field)field, (Object)(trim.value() ? this.replaceAll(value, field.getName(), className) : this.trim(value, field.getName(), className)));
                        continue;
                    }
                    this.trimStrings(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String replaceAll(Object obj, String fieldName, String className) {
        String oldVal = Convert.toStr((Object)obj);
        String newVal = oldVal.replaceAll("\\s+", "");
        log.info("{},{},\u6267\u884c\u8bf7\u6c42\u4f53\u53c2\u6570\u53bb\u9664\u7a7a\u683c,\u7c7b[{}],\u5c5e\u6027[{}],\u65e7\u503c[{}],\u65b0\u503c[{}]", new Object[]{"[webplus]\u573a\u666f\u542f\u52a8\u5668", "[TrimmedRequestBodyAdvice]\u53bb\u9664\u8bf7\u6c42\u4f53\u7a7a\u683c\u9002\u914d\u5668", className, fieldName, oldVal, newVal});
        return newVal;
    }

    private String trim(Object obj, String fieldName, String className) {
        String oldVal = Convert.toStr((Object)obj);
        String newVal = oldVal.trim();
        log.info("{},{},\u6267\u884c\u8bf7\u6c42\u4f53\u53c2\u6570\u53bb\u9664\u7a7a\u683c,\u7c7b[{}],\u5c5e\u6027[{}],\u65e7\u503c[{}],\u65b0\u503c[{}]", new Object[]{"[webplus]\u573a\u666f\u542f\u52a8\u5668", "[TrimmedRequestBodyAdvice]\u53bb\u9664\u8bf7\u6c42\u4f53\u7a7a\u683c\u9002\u914d\u5668", className, fieldName, oldVal, newVal});
        return newVal;
    }
}

