/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.core.filter;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dingwen.io.treasure.base.util.str.StringPlusUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapesValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapesValues[i] = HtmlUtil.cleanHtmlTag((String)values[i]).trim();
            }
            return escapesValues;
        }
        return super.getParameterValues(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.isJsonRequest()) {
            return super.getInputStream();
        }
        String json = StrUtil.str((byte[])IoUtil.readBytes((InputStream)super.getInputStream(), (boolean)false), (Charset)StandardCharsets.UTF_8);
        if (StringPlusUtils.isEmpty((String)json)) {
            return super.getInputStream();
        }
        json = HtmlUtil.cleanHtmlTag((String)json).trim();
        final byte[] jsonBytes = json.getBytes(StandardCharsets.UTF_8);
        final ByteArrayInputStream bis = IoUtil.toStream((byte[])jsonBytes);
        return new ServletInputStream(){

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public int available() {
                return jsonBytes.length;
            }

            public void setReadListener(ReadListener readListener) {
                log.info("{},{}, setReadListener", (Object)"[webplus]\u573a\u666f\u542f\u52a8\u5668", (Object)"[XssHttpServletRequestWrapper]");
            }

            public int read() {
                return bis.read();
            }
        };
    }

    public boolean isJsonRequest() {
        String header = super.getHeader("Content-Type");
        return StringPlusUtils.startsWithIgnoreCase((CharSequence)header, (CharSequence)"application/json");
    }
}

