/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.core.resolver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import top.dingwen.io.treasure.webplus.annotation.Trim;

public class TrimmedReqArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(TrimmedReqArgumentResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Trim.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String parameterName = parameter.getParameterName();
        Trim trim = (Trim)parameter.getParameterAnnotation(Trim.class);
        String[] parameterValues = webRequest.getParameterValues(parameterName);
        if (parameterValues == null) {
            return null;
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            String oldVal = parameterValues[i];
            String newVal = trim.value() ? oldVal.replaceAll(" ", "") : oldVal.trim();
            log.info("{},{},\u53c2\u6570\u5904\u7406,\u8bf7\u6c42\u5730\u5740[{}],\u5c5e\u6027[{}],\u65e7\u503c[{}],\u65b0\u503c[{}]", new Object[]{"[webplus]\u573a\u666f\u542f\u52a8\u5668", "[TrimmedReqArgumentResolver]\u8bf7\u6c42\u53c2\u6570\u53bb\u9664\u7a7a\u683c\u89e3\u6790\u5668", ((ServletWebRequest)webRequest).getRequest().getRequestURI(), parameterName, oldVal, newVal});
            parameterValues[i] = newVal;
        }
        return parameterValues.length == 1 ? parameterValues[0] : parameterValues;
    }
}

