/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.core.view;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.http.ContentType;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;
import top.dingwen.io.treasure.webplus.exception.BusinessException;

public class WebPlusView
extends AbstractView {
    private static final Logger log = LoggerFactory.getLogger(WebPlusView.class);
    private static final String FULL_FILE_NAME = "{}.{}";
    private final String fileName;
    private final ContentType contentType;
    private final Consumer<OutputStream> render;

    public WebPlusView(String fileName, String fileSuffix, ContentType contentType, Consumer<OutputStream> render) {
        this.fileName = CharSequenceUtil.format((CharSequence)FULL_FILE_NAME, (Object[])new Object[]{fileName, fileSuffix});
        this.contentType = contentType;
        this.render = render;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType(this.contentType.getValue());
            response.setHeader("Content-Disposition", CharSequenceUtil.format((CharSequence)"attachment;filename={}", (Object[])new Object[]{new String(this.fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8)}));
            ServletOutputStream outputStream = response.getOutputStream();
            this.render.accept((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error("{},{},\u53d1\u751f\u5f02\u5e38,\u9519\u8bef\u6d88\u606f:{}", new Object[]{"[webplus]\u573a\u666f\u542f\u52a8\u5668", "[WebPlusView]\u81ea\u5b9a\u4e49MVCFile\u89c6\u56fe", e.getMessage()});
            throw new BusinessException("[webplus]\u573a\u666f\u542f\u52a8\u5668", new String[]{"\u6e32\u67d3\u5931\u8d25[Render failure]"});
        }
    }
}

