/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.exception;

import cn.hutool.core.util.ObjectUtil;
import top.dingwen.io.treasure.webplus.util.message.MessageUtils;

public class BaseRuntimeException
extends RuntimeException {
    private final String module;
    private final Integer code;
    private final String key;
    private final String message;
    private final String[] args;
    private static final long serialVersionUID = 7277630060515118004L;

    public BaseRuntimeException(String module, Integer code, String key, String message, String[] args) {
        this.module = module;
        this.code = code;
        this.key = key;
        this.message = message;
        this.args = args;
    }

    public BaseRuntimeException(String module, String key, String[] args) {
        this(module, null, key, null, args);
    }

    public BaseRuntimeException(Integer code, String key, String[] args) {
        this(null, code, key, null, args);
    }

    public BaseRuntimeException(String module, Integer code, String key, String[] args) {
        this(module, code, key, null, args);
    }

    public BaseRuntimeException(String module, String message) {
        this(module, null, null, message, null);
    }

    public BaseRuntimeException(Integer code, String key, String message, String[] args) {
        this("", code, key, message, args);
    }

    public BaseRuntimeException(String key, String[] args) {
        this(null, null, key, null, args);
    }

    public BaseRuntimeException(String message) {
        this(null, null, null, message, null);
    }

    public BaseRuntimeException() {
        this(null, null, null, null, null);
    }

    @Override
    public String getMessage() {
        if (ObjectUtil.isNotEmpty((Object)this.key)) {
            return MessageUtils.message(this.key, this.args);
        }
        return this.message;
    }

    public String getModule() {
        return this.module;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getArgs() {
        return this.args;
    }
}

