/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.exception;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.nio.file.AccessDeniedException;
import java.sql.SQLSyntaxErrorException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.NoSuchMessageException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.yaml.snakeyaml.constructor.DuplicateKeyException;
import top.dingwen.io.treasure.base.support.ICurrentUserService;
import top.dingwen.io.treasure.webplus.autoconfigure.WebPlusProperties;
import top.dingwen.io.treasure.webplus.exception.BaseRuntimeException;
import top.dingwen.io.treasure.webplus.exception.GlobalExceptionMsgSender;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVOGenerator;
import top.dingwen.io.treasure.webplus.util.servlet.ServletUtils;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Resource
    private WebPlusProperties webPlusProperties;
    @Resource
    private ICurrentUserService currentUserService;

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResultVO<String> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.request.method.not.support", HttpStatus.METHOD_NOT_ALLOWED.value(), this.getRequestUri(request), request.getMethod());
    }

    @ExceptionHandler(value={SQLSyntaxErrorException.class})
    public ResultVO<String> handleSQLSyntaxErrorException(SQLSyntaxErrorException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces(e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genInternationalFailureResultOnlyMessage("treasure.webplus.request.method.not.support", this.getRequestUri(request), request.getMethod());
    }

    @ExceptionHandler(value={BindException.class})
    public ResultVO<String> handleBindException(HttpServletRequest request, BindException e) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.params.bind.exception", HttpStatus.BAD_REQUEST.value(), this.getBindErrInfo(e.getBindingResult()));
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResultVO<String> handleDuplicateKeyException(DuplicateKeyException e) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        log.error("\u8fdd\u53cd\u6570\u636e\u552f\u4e00\u6027\u7ea6\u675f,msg{}", (Object)e.getMessage(), (Object)e);
        return ResultVOGenerator.genInternationalFailureResultOnlyMessage("treasure.webplus.not.unique.exception", new String[0]);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResultVO<String> handleAccessDeniedException(AccessDeniedException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces(e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u6743\u9650\u6821\u9a8c\u5931\u8d25'{}'", (Object)request.getRequestURI(), (Object)e.getMessage());
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.no.permission.exception", HttpStatus.FORBIDDEN.value(), e.getMessage());
    }

    @ExceptionHandler(value={RuntimeJsonMappingException.class})
    public ResultVO<String> handleRuntimeJsonMappingException(RuntimeJsonMappingException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53c2\u6570\u5f02\u5e38'{}'", new Object[]{request.getRequestURI(), e.getMessage(), e});
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.params.exception", HttpStatus.BAD_REQUEST.value(), e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResultVO<String> handleHttpMessageNotReadableException(HttpMessageNotReadableException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53c2\u6570\u5f02\u5e38'{}'", new Object[]{request.getRequestURI(), e.getMessage(), e});
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.params.exception", HttpStatus.BAD_REQUEST.value(), e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultVO<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53c2\u6570\u5f02\u5e38'{}'", (Object)request.getRequestURI(), (Object)e.getMessage());
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.params.exception", HttpStatus.BAD_REQUEST.value(), this.getBindErrInfo(e.getBindingResult()));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResultVO<String> handleMissingServletRequestParameterException(MissingServletRequestParameterException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53c2\u6570\u5f02\u5e38'{}'", (Object)request.getRequestURI(), (Object)e.getMessage());
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.params.exception", HttpStatus.BAD_REQUEST.value(), e.getMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResultVO<String> handleConstraintViolationException(ConstraintViolationException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53c2\u6570\u5f02\u5e38'{}'", (Object)request.getRequestURI(), (Object)e.getMessage());
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.params.exception", HttpStatus.BAD_REQUEST.value(), e.getMessage());
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResultVO<String> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        String stackTracesMsg = this.printStackTraces((Exception)e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.file.size.limit.exception", HttpStatus.BAD_REQUEST.value(), new String[0]);
    }

    @ExceptionHandler(value={BaseRuntimeException.class})
    public ResultVO<String> handleBaseRuntimeException(HttpServletRequest request, BaseRuntimeException e) {
        String stackTracesMsg = this.printStackTraces(e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genInternationalFailureResultMessageAndCodeAndModule(e.getModule(), e.getKey(), e.getCode(), e.getArgs());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResultVO<String> handleIllegalArgumentException(HttpServletRequest request, IllegalArgumentException e) {
        String stackTracesMsg = this.printStackTraces(e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genFailureResult(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR.value());
    }

    @ExceptionHandler(value={Exception.class})
    public ResultVO<String> handleException(Exception e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces(e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genInternationalFailureResultOnlyMessage("treasure.system.unknown.exception", new String[0]);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object handle404Error(HttpServletRequest request, NoHandlerFoundException ex) {
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.system.not.find.exception", HttpStatus.NOT_FOUND.value(), new String[0]);
    }

    @ExceptionHandler(value={NoSuchMessageException.class})
    public Object handleNoSuchMessageException(HttpServletRequest request, NoSuchMessageException ex) {
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.message.not.such.exception", HttpStatus.INTERNAL_SERVER_ERROR.value(), new String[0]);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResultVO<String> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e, HttpServletRequest request) {
        Throwable rootCause = this.getRootCause((Throwable)e);
        if (rootCause instanceof BaseRuntimeException) {
            return this.handleBaseRuntimeException(request, (BaseRuntimeException)rootCause);
        }
        String stackTracesMsg = this.printStackTraces((Exception)rootCause);
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genInternationalFailureResultMessageAndCode("treasure.webplus.params.exception", HttpStatus.BAD_REQUEST.value(), e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResultVO<String> handleRuntimeException(RuntimeException e, HttpServletRequest request) {
        String stackTracesMsg = this.printStackTraces(e);
        this.exMsgSender(stackTracesMsg, e.getMessage());
        this.printLog(request, stackTracesMsg);
        return ResultVOGenerator.genInternationalFailureResultOnlyMessage("treasure.system.runtime.exception", new String[0]);
    }

    private String getRequestUri(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    private void printLog(HttpServletRequest request, String stackTracesMsg) {
        StringBuilder builder = new StringBuilder();
        String url = this.getRequestUri(request);
        builder.append("REQUEST_URI").append(url).append("\n").append("\n").append("STACK_INFO").append("\n").append("\n").append(stackTracesMsg);
        log.error(builder.toString());
    }

    private String printStackTraces(Exception e) {
        StackTraceElement[] stackTraces = e.getStackTrace();
        StringBuilder builder = new StringBuilder();
        builder.append(e.getClass().getName()).append(":").append(e.getLocalizedMessage()).append("\n");
        for (StackTraceElement stackTrace : stackTraces) {
            String lineMsg = "         at ";
            lineMsg = lineMsg + stackTrace.getClassName() + "(" + stackTrace.getFileName() + ":" + stackTrace.getLineNumber() + ")\n";
            builder.append(lineMsg);
        }
        return builder.toString();
    }

    private String getBindErrInfo(BindingResult bindingResult) {
        return bindingResult.getFieldErrors().parallelStream().map(ele -> ele.getField().concat(":").concat(Objects.requireNonNull(ele.getDefaultMessage()))).collect(Collectors.joining(","));
    }

    private void exMsgSender(String stackTracesMsg, String exMsg) {
        if (Boolean.FALSE.equals(Convert.toBool((Object)this.webPlusProperties.getGlobalExMsgHandlerEnabled(), (Boolean)false))) {
            return;
        }
        Long userId = (Long)this.currentUserService.getUserId();
        String username = this.currentUserService.getUserName();
        String msgTemplate = "\u7528\u6237[{}],userId[{}],\u8bf7\u6c42\u5730\u5740[{}],\u5165\u53c2[{}],\u8bf7\u6c42\u4f53\u53c2\u6570[{}],\u53d1\u751f\u5f02\u5e38,\u6d88\u606f[{}],\u5806\u6808\u4fe1\u606f[{}]";
        String url = this.getRequestUri(ServletUtils.getRequest());
        String parameters = ServletUtils.getParameters();
        String body = ServletUtil.getBody((ServletRequest)((ServletRequest)Objects.requireNonNull(ServletUtils.getRequest())));
        String msg = CharSequenceUtil.format((CharSequence)msgTemplate, (Object[])new Object[]{username, userId, url, parameters, body, exMsg, stackTracesMsg});
        Map handlers = SpringUtil.getBeansOfType(GlobalExceptionMsgSender.class);
        for (Map.Entry handlerEntry : handlers.entrySet()) {
            GlobalExceptionMsgSender sender = (GlobalExceptionMsgSender)handlerEntry.getValue();
            sender.sendMsg(msg);
        }
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable cause = null;
        Throwable result = throwable;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }
}

