/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.util.checker.handler;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Objects;
import org.springframework.util.StringUtils;
import top.dingwen.io.treasure.base.util.reflect.ReflectUtils;
import top.dingwen.io.treasure.base.util.str.StringPlusUtils;
import top.dingwen.io.treasure.webplus.util.checker.CheckerException;
import top.dingwen.io.treasure.webplus.util.checker.Condition;

public class ConditionHandler {
    public static boolean handleCustom(Object obj, Condition condition) {
        if (condition.getResultPredicate().apply(obj)) {
            throw new CheckerException(new String[]{condition.getDesc()});
        }
        return true;
    }

    public static boolean handleNe(Object obj, Condition condition) {
        try {
            Class<?> targetClass = obj.getClass();
            Field field = targetClass.getDeclaredField(condition.getField());
            field.setAccessible(true);
            Object result = field.get(obj);
            if (Objects.equals(result, condition.getVal())) {
                ConditionHandler.throwBizError(condition);
            }
        }
        catch (CheckerException e) {
            throw e;
        }
        catch (Exception e) {
            ConditionHandler.throwFieldError(condition);
        }
        return true;
    }

    private static void throwFieldError(Condition condition) {
        ConditionHandler.throwMsg(String.format("\u5b57\u6bb5(%s)\u4e0d\u5b58\u5728", condition.getField()));
    }

    private static void throwBizError(Condition condition) {
        String msg = StringUtils.isEmpty((Object)condition.getDesc()) ? String.format("\u5b57\u6bb5(%s)\u503c\u9519\u8bef", condition.getField()) : condition.getDesc();
        ConditionHandler.throwMsg(msg);
    }

    public static boolean handleNotNull(Object obj, Condition condition) {
        try {
            Class<?> targetClass = obj.getClass();
            Field field = targetClass.getDeclaredField(condition.getField());
            field.setAccessible(true);
            Object result = field.get(obj);
            if (Objects.isNull(result)) {
                ConditionHandler.throwBizError(condition);
            }
        }
        catch (CheckerException e) {
            throw e;
        }
        catch (Exception e) {
            ConditionHandler.throwFieldError(condition);
        }
        return true;
    }

    public static boolean handleNotNullNe(Object obj, Condition condition) {
        try {
            Class<?> targetClass = obj.getClass();
            Field field = targetClass.getDeclaredField(condition.getField());
            field.setAccessible(true);
            Object result = field.get(obj);
            if (Objects.isNull(result) || result.equals(condition.getVal())) {
                ConditionHandler.throwBizError(condition);
            }
        }
        catch (CheckerException e) {
            throw e;
        }
        catch (Exception e) {
            ConditionHandler.throwFieldError(condition);
        }
        return true;
    }

    public static boolean handleNotBlank(Object obj, Condition condition) {
        try {
            Class<?> targetClass = obj.getClass();
            Field field = ReflectUtils.getField(targetClass, (String)condition.getField());
            field.setAccessible(true);
            Object result = field.get(obj);
            if (Objects.isNull(result) || StringPlusUtils.isNotBlank((CharSequence)result.toString())) {
                ConditionHandler.throwBizError(condition);
            }
        }
        catch (CheckerException e) {
            throw e;
        }
        catch (Exception e) {
            ConditionHandler.throwFieldError(condition);
        }
        return true;
    }

    public static boolean handleIn(Object obj, Condition condition) {
        try {
            Class<?> targetClass = obj.getClass();
            Field field = targetClass.getDeclaredField(condition.getField());
            field.setAccessible(true);
            Object result = field.get(obj);
            Object val = condition.getVal();
            if (val instanceof Collection) {
                Collection temp = (Collection)val;
                if (Objects.isNull(result) || !temp.contains(result)) {
                    ConditionHandler.throwBizError(condition);
                }
            }
        }
        catch (CheckerException e) {
            throw e;
        }
        catch (Exception e) {
            ConditionHandler.throwFieldError(condition);
        }
        return true;
    }

    public static void throwMsg(String msg) {
        throw new CheckerException(new String[]{msg});
    }
}

