/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.webplus.util.message;

import cn.hutool.extra.spring.SpringUtil;
import java.util.Locale;
import java.util.Objects;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import top.dingwen.io.treasure.base.util.spring.SpringUtils;
import top.dingwen.io.treasure.webplus.core.resolver.I18nLocaleResolver;
import top.dingwen.io.treasure.webplus.util.servlet.ServletUtils;

public final class MessageUtils {
    public static String message(String key, String ... args) {
        I18nLocaleResolver i18nLocaleResolver = (I18nLocaleResolver)SpringUtils.getBean(I18nLocaleResolver.class);
        if (Objects.nonNull(i18nLocaleResolver)) {
            LocaleContextHolder.setLocale((Locale)i18nLocaleResolver.resolveLocale(ServletUtils.getRequest()));
        }
        MessageSource webPlusMessageSource = (MessageSource)SpringUtil.getBean((String)"webPlusMessageSource", MessageSource.class);
        MessageSource messageSource = (MessageSource)SpringUtil.getBean((String)"messageSource", MessageSource.class);
        if (Objects.isNull(webPlusMessageSource)) {
            if (Objects.isNull(messageSource)) {
                return "";
            }
            return messageSource.getMessage(key, (Object[])args, LocaleContextHolder.getLocale());
        }
        try {
            return webPlusMessageSource.getMessage(key, (Object[])args, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            return messageSource.getMessage(key, (Object[])args, LocaleContextHolder.getLocale());
        }
    }

    private MessageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

