/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.draw.element;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Rect;
import top.e404.skiko.draw.DrawElement;
import top.e404.skiko.draw.Pointer;
import top.e404.skiko.util.ImageKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ8\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0007H\u0016J$\u00102\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t032\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005H\u0016R\u001a\u0010\u000b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0016\"\u0004\b\u001f\u0010\u0018R\u001a\u0010 \u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010\u0018R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000e\"\u0004\b$\u0010\u0010R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000e\"\u0004\b&\u0010\u0010\u00a8\u00066"}, d2={"Ltop/e404/skiko/draw/element/Pic;", "Ltop/e404/skiko/draw/DrawElement;", "pic", "Lorg/jetbrains/skia/Image;", "left", "", "center", "", "radius", "", "top", "bottom", "(Lorg/jetbrains/skia/Image;IZFFF)V", "getBottom", "()F", "setBottom", "(F)V", "getCenter", "()Z", "setCenter", "(Z)V", "getLeft", "()I", "setLeft", "(I)V", "getPic", "()Lorg/jetbrains/skia/Image;", "setPic", "(Lorg/jetbrains/skia/Image;)V", "picH", "getPicH", "setPicH", "picW", "getPicW", "setPicW", "getRadius", "setRadius", "getTop", "setTop", "drawToBoard", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "pointer", "Ltop/e404/skiko/draw/Pointer;", "paint", "Lorg/jetbrains/skia/Paint;", "width", "imagePadding", "debug", "size", "Lkotlin/Pair;", "minWidth", "maxWidth", "skiko-util-draw"})
public final class Pic
implements DrawElement {
    @NotNull
    private Image pic;
    private int left;
    private boolean center;
    private float radius;
    private float top;
    private float bottom;
    private int picW;
    private int picH;

    public Pic(@NotNull Image pic, int left, boolean center, float radius, float top, float bottom) {
        Intrinsics.checkNotNullParameter((Object)pic, (String)"pic");
        this.pic = pic;
        this.left = left;
        this.center = center;
        this.radius = radius;
        this.top = top;
        this.bottom = bottom;
        this.picW = this.pic.getWidth();
        this.picH = this.pic.getHeight();
    }

    @NotNull
    public final Image getPic() {
        return this.pic;
    }

    public final void setPic(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"<set-?>");
        this.pic = image;
    }

    public final int getLeft() {
        return this.left;
    }

    public final void setLeft(int n) {
        this.left = n;
    }

    public final boolean getCenter() {
        return this.center;
    }

    public final void setCenter(boolean bl) {
        this.center = bl;
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float f) {
        this.radius = f;
    }

    public final float getTop() {
        return this.top;
    }

    public final void setTop(float f) {
        this.top = f;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final void setBottom(float f) {
        this.bottom = f;
    }

    public final int getPicW() {
        return this.picW;
    }

    public final void setPicW(int n) {
        this.picW = n;
    }

    public final int getPicH() {
        return this.picH;
    }

    public final void setPicH(int n) {
        this.picH = n;
    }

    @Override
    @NotNull
    public Pair<Float, Float> size(int minWidth, int maxWidth) {
        int maxW;
        int n = maxW = !this.center ? maxWidth - this.left : maxWidth;
        if (this.pic.getWidth() > maxW) {
            this.picW = maxW;
            this.picH = this.pic.getHeight() * this.picW / this.pic.getWidth();
            this.pic = ImageKt.resize$default((Image)this.pic, (int)this.picW, (int)this.picH, (boolean)false, (int)4, null);
        }
        return TuplesKt.to((Object)Float.valueOf((float)this.picW + (float)(!this.center ? this.left : 0)), (Object)Float.valueOf((float)this.picH + this.top + this.bottom));
    }

    @Override
    public void drawToBoard(@NotNull Canvas canvas, @NotNull Pointer pointer, @NotNull Paint paint, int width, int imagePadding, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        float left = this.center ? (float)(width + 2 * imagePadding - this.picW) / 2.0f : pointer.getX() + (float)this.left;
        float t = pointer.getY() + this.top;
        if (debug) {
            canvas.drawRect(Rect.Companion.makeXYWH(left, t, (float)this.pic.getWidth(), (float)this.pic.getHeight()), DrawElement.Companion.getDebugPaint());
        }
        ImageKt.drawImageRRect((Canvas)canvas, (Image)this.pic, (float)left, (float)t, (float)this.pic.getWidth(), (float)this.pic.getHeight(), (float)this.radius);
        pointer.setY(pointer.getY() + ((float)this.picH + this.top + this.bottom));
    }
}

