/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.draw.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.TextLine;
import top.e404.skiko.draw.DrawElement;
import top.e404.skiko.draw.DrawElementKt;
import top.e404.skiko.draw.Pointer;
import top.e404.skiko.util.Colors;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ8\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u000bH\u0016J$\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0016R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000f\"\u0004\b$\u0010\u0011R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0013\"\u0004\b&\u0010\u0015\u00a8\u00067"}, d2={"Ltop/e404/skiko/draw/element/Text;", "Ltop/e404/skiko/draw/DrawElement;", "content", "", "font", "Lorg/jetbrains/skia/Font;", "color", "", "udPadding", "left", "textIndent", "", "center", "(Ljava/lang/String;Lorg/jetbrains/skia/Font;IIIZZ)V", "getCenter", "()Z", "setCenter", "(Z)V", "getColor", "()I", "setColor", "(I)V", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "getFont", "()Lorg/jetbrains/skia/Font;", "setFont", "(Lorg/jetbrains/skia/Font;)V", "getLeft", "setLeft", "lines", "", "Lorg/jetbrains/skia/TextLine;", "getTextIndent", "setTextIndent", "getUdPadding", "setUdPadding", "drawToBoard", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "pointer", "Ltop/e404/skiko/draw/Pointer;", "paint", "Lorg/jetbrains/skia/Paint;", "width", "imagePadding", "debug", "size", "Lkotlin/Pair;", "", "minWidth", "maxWidth", "skiko-util-draw"})
public class Text
implements DrawElement {
    @NotNull
    private String content;
    @NotNull
    private Font font;
    private int color;
    private int udPadding;
    private int left;
    private boolean textIndent;
    private boolean center;
    @NotNull
    private List<TextLine> lines;

    public Text(@NotNull String content, @NotNull Font font, int color, int udPadding, int left, boolean textIndent, boolean center) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.content = content;
        this.font = font;
        this.color = color;
        this.udPadding = udPadding;
        this.left = left;
        this.textIndent = textIndent;
        this.center = center;
        this.lines = CollectionsKt.emptyList();
    }

    public /* synthetic */ Text(String string, Font font, int n, int n2, int n3, boolean bl, boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = Colors.WHITE.getArgb();
        }
        if ((n4 & 8) != 0) {
            n2 = 20;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            bl = false;
        }
        if ((n4 & 0x40) != 0) {
            bl2 = true;
        }
        this(string, font, n, n2, n3, bl, bl2);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public final void setContent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.content = string;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    public final void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.font = font;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final int getUdPadding() {
        return this.udPadding;
    }

    public final void setUdPadding(int n) {
        this.udPadding = n;
    }

    public final int getLeft() {
        return this.left;
    }

    public final void setLeft(int n) {
        this.left = n;
    }

    public final boolean getTextIndent() {
        return this.textIndent;
    }

    public final void setTextIndent(boolean bl) {
        this.textIndent = bl;
    }

    public final boolean getCenter() {
        return this.center;
    }

    public final void setCenter(boolean bl) {
        this.center = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Float, Float> size(int minWidth, int maxWidth) {
        void $this$mapTo$iv$iv;
        Object text = this.content;
        if (!this.center && this.textIndent) {
            text = "\u3000\u3000" + (String)text;
        }
        int left = this.center ? 0 : this.left;
        Pair<List<TextLine>, Float> pair = DrawElementKt.splitByWidth((String)text, maxWidth - left, this.font, left);
        List lines = (List)pair.component1();
        float width = ((Number)pair.component2()).floatValue();
        this.lines = lines;
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextLine textLine = (TextLine)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(it.getDescent() - it.getAscent()));
        }
        float height = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv)) + (float)(lines.size() * this.udPadding);
        return TuplesKt.to((Object)Float.valueOf(width + (float)left), (Object)Float.valueOf(height));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawToBoard(@NotNull Canvas canvas, @NotNull Pointer pointer, @NotNull Paint paint, int width, int imagePadding, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        pointer.setY(pointer.getY() - (float)(this.udPadding / 2));
        for (TextLine line : this.lines) {
            void it;
            Paint paint2;
            pointer.setY(pointer.getY() + ((float)this.udPadding - line.getAscent()));
            Paint paint3 = paint2 = paint;
            float f = pointer.getY();
            float f2 = this.center ? ((float)(width + imagePadding * 2) - line.getWidth()) / (float)2 : pointer.getX() + (float)this.left;
            TextLine textLine = line;
            Canvas canvas2 = canvas;
            boolean bl = false;
            it.setColor(this.color);
            Unit unit = Unit.INSTANCE;
            canvas2.drawTextLine(textLine, f2, f, paint2);
            pointer.setY(pointer.getY() + line.getDescent());
        }
        pointer.setY(pointer.getY() + (float)(this.udPadding / 2));
    }
}

