/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.draw.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.TextLine;
import top.e404.skiko.draw.DrawElement;
import top.e404.skiko.draw.DrawElementKt;
import top.e404.skiko.draw.Pointer;
import top.e404.skiko.util.Colors;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u00014BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fJ8\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0016J$\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\bH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000e\"\u0004\b\"\u0010\u0010\u00a8\u00065"}, d2={"Ltop/e404/skiko/draw/element/TextList;", "Ltop/e404/skiko/draw/DrawElement;", "contents", "", "", "font", "Lorg/jetbrains/skia/Font;", "color", "", "udPadding", "left", "index", "(Ljava/util/List;Lorg/jetbrains/skia/Font;IIILjava/lang/String;)V", "getColor", "()I", "setColor", "(I)V", "getContents", "()Ljava/util/List;", "setContents", "(Ljava/util/List;)V", "getFont", "()Lorg/jetbrains/skia/Font;", "setFont", "(Lorg/jetbrains/skia/Font;)V", "getIndex", "()Ljava/lang/String;", "setIndex", "(Ljava/lang/String;)V", "getLeft", "setLeft", "lines", "Ltop/e404/skiko/draw/element/TextList$TextListLine;", "getUdPadding", "setUdPadding", "drawToBoard", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "pointer", "Ltop/e404/skiko/draw/Pointer;", "paint", "Lorg/jetbrains/skia/Paint;", "width", "imagePadding", "debug", "", "size", "Lkotlin/Pair;", "", "minWidth", "maxWidth", "TextListLine", "skiko-util-draw"})
public class TextList
implements DrawElement {
    @NotNull
    private List<String> contents;
    @NotNull
    private Font font;
    private int color;
    private int udPadding;
    private int left;
    @Nullable
    private String index;
    @NotNull
    private List<TextListLine> lines;

    public TextList(@NotNull List<String> contents, @NotNull Font font, int color, int udPadding, int left, @Nullable String index) {
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.contents = contents;
        this.font = font;
        this.color = color;
        this.udPadding = udPadding;
        this.left = left;
        this.index = index;
        this.lines = CollectionsKt.emptyList();
    }

    public /* synthetic */ TextList(List list, Font font, int n, int n2, int n3, String string, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = Colors.WHITE.getArgb();
        }
        if ((n4 & 8) != 0) {
            n2 = 10;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            string = null;
        }
        this(list, font, n, n2, n3, string);
    }

    @NotNull
    public final List<String> getContents() {
        return this.contents;
    }

    public final void setContents(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.contents = list;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    public final void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.font = font;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final int getUdPadding() {
        return this.udPadding;
    }

    public final void setUdPadding(int n) {
        this.udPadding = n;
    }

    public final int getLeft() {
        return this.left;
    }

    public final void setLeft(int n) {
        this.left = n;
    }

    @Nullable
    public final String getIndex() {
        return this.index;
    }

    public final void setIndex(@Nullable String string) {
        this.index = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Float, Float> size(int minWidth, int maxWidth) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$mapTo$iv$iv4;
        void $this$map$iv;
        int length = String.valueOf(this.contents.size() - 1).length();
        int indexWidth = (int)TextLine.Companion.make((String)(this.index == null ? StringsKt.repeat((CharSequence)"0", (int)length) + ". " : this.index), this.font).getWidth();
        Iterable iterable = CollectionsKt.withIndex((Iterable)this.contents);
        Object object = this;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            String text = (String)indexedValue.component2();
            collection.add(new TextListLine(TextList.size$getIndex(this, length, index), indexWidth, text, this.font, this.color, this.udPadding, this.left));
        }
        ((TextList)object).lines = (List)destination$iv$iv;
        Iterable $this$map$iv2 = this.lines;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            TextListLine bl = (TextListLine)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(it.size(maxWidth));
        }
        List sizes = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = sizes;
        boolean $i$f$map222 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Pair bl2 = (Pair)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object.add(Float.valueOf(((Number)it.getFirst()).floatValue()));
        }
        Iterator $i$f$map222 = ((Iterable)((List)destination$iv$iv3)).iterator();
        if (!$i$f$map222.hasNext()) {
            throw new NoSuchElementException();
        }
        float it = ((Number)$i$f$map222.next()).floatValue();
        boolean bl = false;
        while ($i$f$map222.hasNext()) {
            float it2 = ((Number)$i$f$map222.next()).floatValue();
            $i$a$-maxOf-TextList$size$width$2 = false;
            it = Math.max(it, it2);
        }
        float width = it;
        Iterable $this$map$iv4 = sizes;
        boolean $i$f$map3 = false;
        Iterable it2 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Pair bl3 = (Pair)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl4 = false;
            object.add(Float.valueOf(((Number)it3.getSecond()).floatValue()));
        }
        float height = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv4)) + (float)(sizes.size() * this.udPadding);
        return TuplesKt.to((Object)Float.valueOf(width), (Object)Float.valueOf(height));
    }

    @Override
    public void drawToBoard(@NotNull Canvas canvas, @NotNull Pointer pointer, @NotNull Paint paint, int width, int imagePadding, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        pointer.setY(pointer.getY() + (float)(this.udPadding / 2));
        Iterator<TextListLine> iterator = this.lines.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            TextListLine line = iterator.next();
            if (index != 0) {
                pointer.setY(pointer.getY() + (float)this.udPadding);
            }
            line.drawToBoard(canvas, pointer, paint);
        }
        pointer.setY(pointer.getY() + (float)(this.udPadding / 2));
    }

    private static final String size$getIndex(TextList this$0, int length, int i) {
        Object object = this$0.index;
        if (object == null) {
            object = StringsKt.padStart((String)String.valueOf(i + 1), (int)length, (char)' ') + ". ";
        }
        return object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u00020\u0005R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000e\"\u0004\b'\u0010\u0010\u00a8\u00064"}, d2={"Ltop/e404/skiko/draw/element/TextList$TextListLine;", "", "index", "", "indexWidth", "", "content", "font", "Lorg/jetbrains/skia/Font;", "color", "udPadding", "left", "(Ljava/lang/String;ILjava/lang/String;Lorg/jetbrains/skia/Font;III)V", "getColor", "()I", "setColor", "(I)V", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "getFont", "()Lorg/jetbrains/skia/Font;", "setFont", "(Lorg/jetbrains/skia/Font;)V", "getIndex", "setIndex", "getIndexWidth", "setIndexWidth", "getLeft", "setLeft", "lines", "", "Lorg/jetbrains/skia/TextLine;", "getLines", "()Ljava/util/List;", "setLines", "(Ljava/util/List;)V", "getUdPadding", "setUdPadding", "drawToBoard", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "pointer", "Ltop/e404/skiko/draw/Pointer;", "paint", "Lorg/jetbrains/skia/Paint;", "size", "Lkotlin/Pair;", "", "maxWidth", "skiko-util-draw"})
    public static final class TextListLine {
        @NotNull
        private String index;
        private int indexWidth;
        @NotNull
        private String content;
        @NotNull
        private Font font;
        private int color;
        private int udPadding;
        private int left;
        public List<TextLine> lines;

        public TextListLine(@NotNull String index, int indexWidth, @NotNull String content, @NotNull Font font, int color, int udPadding, int left) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            this.index = index;
            this.indexWidth = indexWidth;
            this.content = content;
            this.font = font;
            this.color = color;
            this.udPadding = udPadding;
            this.left = left;
        }

        @NotNull
        public final String getIndex() {
            return this.index;
        }

        public final void setIndex(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.index = string;
        }

        public final int getIndexWidth() {
            return this.indexWidth;
        }

        public final void setIndexWidth(int n) {
            this.indexWidth = n;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final void setContent(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.content = string;
        }

        @NotNull
        public final Font getFont() {
            return this.font;
        }

        public final void setFont(@NotNull Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
            this.font = font;
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final int getUdPadding() {
            return this.udPadding;
        }

        public final void setUdPadding(int n) {
            this.udPadding = n;
        }

        public final int getLeft() {
            return this.left;
        }

        public final void setLeft(int n) {
            this.left = n;
        }

        @NotNull
        public final List<TextLine> getLines() {
            List<TextLine> list = this.lines;
            if (list != null) {
                return list;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"lines");
            return null;
        }

        public final void setLines(@NotNull List<TextLine> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.lines = list;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<Float, Float> size(int maxWidth) {
            void it;
            Pair<List<TextLine>, Float> pair = DrawElementKt.splitByWidth(this.content, maxWidth - this.left - this.indexWidth, this.font, this.left);
            this.setLines((List)pair.getFirst());
            FontMetrics fontMetrics = this.font.getMetrics();
            float f = this.getLines().size();
            Float f2 = Float.valueOf(((Number)pair.getSecond()).floatValue() + (float)this.left + (float)this.indexWidth);
            boolean bl = false;
            float f3 = it.getDescent() - it.getAscent();
            return TuplesKt.to((Object)f2, (Object)Float.valueOf(f * (f3 + (float)this.udPadding) - (float)this.udPadding));
        }

        /*
         * WARNING - void declaration
         */
        public final void drawToBoard(@NotNull Canvas canvas, @NotNull Pointer pointer, @NotNull Paint paint) {
            void it;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            pointer.setY(pointer.getY() - this.font.getMetrics().getAscent());
            TextLine indexLine = TextLine.Companion.make(this.index, this.font);
            float x = pointer.getX() + (float)this.left + (float)this.indexWidth - indexLine.getWidth();
            Object object = paint;
            Paint paint2 = object;
            float f = pointer.getY();
            float f2 = x;
            TextLine textLine = indexLine;
            Canvas canvas2 = canvas;
            boolean bl = false;
            it.setColor(this.color);
            Unit unit = Unit.INSTANCE;
            canvas2.drawTextLine(textLine, f2, f, (Paint)object);
            x = pointer.getX() + (float)this.left + (float)this.indexWidth;
            object = this.getLines().iterator();
            int n = 0;
            while (object.hasNext()) {
                void it2;
                Paint paint3;
                int index = n++;
                TextLine line = (TextLine)object.next();
                if (index != 0) {
                    pointer.setY(pointer.getY() + ((float)this.udPadding - this.font.getMetrics().getAscent()));
                }
                Paint paint4 = paint3 = paint;
                f = pointer.getY();
                f2 = x;
                textLine = line;
                canvas2 = canvas;
                boolean bl2 = false;
                it2.setColor(this.color);
                unit = Unit.INSTANCE;
                canvas2.drawTextLine(textLine, f2, f, paint3);
                pointer.setY(pointer.getY() + this.font.getMetrics().getDescent());
            }
        }
    }
}

