/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.draw.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.TextLine;
import top.e404.skiko.draw.DrawElement;
import top.e404.skiko.draw.DrawElementKt;
import top.e404.skiko.draw.Pointer;
import top.e404.skiko.util.Colors;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J8\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u000fH\u0016J$\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0@2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0016R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0014\"\u0004\b&\u0010'R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u001bR\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0012\"\u0004\b.\u0010\u001bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0012\"\u0004\b0\u0010\u001bR\u001a\u00101\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0014\"\u0004\b3\u0010'\u00a8\u0006C"}, d2={"Ltop/e404/skiko/draw/element/TextLineBlock;", "Ltop/e404/skiko/draw/DrawElement;", "content", "", "lineSpace", "", "font", "Lorg/jetbrains/skia/Font;", "color", "bgColor", "bgRadius", "", "padding", "margin", "center", "", "(Ljava/lang/String;ILorg/jetbrains/skia/Font;IIFIIZ)V", "getBgColor", "()I", "getBgRadius", "()F", "getCenter", "()Z", "setCenter", "(Z)V", "getColor", "setColor", "(I)V", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "getFont", "()Lorg/jetbrains/skia/Font;", "setFont", "(Lorg/jetbrains/skia/Font;)V", "h", "getH", "setH", "(F)V", "getLineSpace", "setLineSpace", "lines", "", "Lorg/jetbrains/skia/TextLine;", "getMargin", "setMargin", "getPadding", "setPadding", "w", "getW", "setW", "drawToBoard", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "pointer", "Ltop/e404/skiko/draw/Pointer;", "paint", "Lorg/jetbrains/skia/Paint;", "width", "imagePadding", "debug", "size", "Lkotlin/Pair;", "minWidth", "maxWidth", "skiko-util-draw"})
@SourceDebugExtension(value={"SMAP\nTextLineBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLineBlock.kt\ntop/e404/skiko/draw/element/TextLineBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1549#2:81\n1620#2,3:82\n1#3:85\n*S KotlinDebug\n*F\n+ 1 TextLineBlock.kt\ntop/e404/skiko/draw/element/TextLineBlock\n*L\n43#1:81\n43#1:82,3\n*E\n"})
public class TextLineBlock
implements DrawElement {
    @NotNull
    private String content;
    private int lineSpace;
    @NotNull
    private Font font;
    private int color;
    private final int bgColor;
    private final float bgRadius;
    private int padding;
    private int margin;
    private boolean center;
    @NotNull
    private List<TextLine> lines;
    private float w;
    private float h;

    public TextLineBlock(@NotNull String content, int lineSpace, @NotNull Font font, int color, int bgColor, float bgRadius, int padding, int margin, boolean center) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.content = content;
        this.lineSpace = lineSpace;
        this.font = font;
        this.color = color;
        this.bgColor = bgColor;
        this.bgRadius = bgRadius;
        this.padding = padding;
        this.margin = margin;
        this.center = center;
        this.lines = CollectionsKt.emptyList();
    }

    public /* synthetic */ TextLineBlock(String string, int n, Font font, int n2, int n3, float f, int n4, int n5, boolean bl, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 2) != 0) {
            n = 20;
        }
        if ((n6 & 8) != 0) {
            n2 = Colors.WHITE.getArgb();
        }
        if ((n6 & 0x10) != 0) {
            n3 = Colors.LIGHT_BLUE.getArgb();
        }
        if ((n6 & 0x20) != 0) {
            f = 20.0f;
        }
        if ((n6 & 0x40) != 0) {
            n4 = 20;
        }
        if ((n6 & 0x80) != 0) {
            n5 = 20;
        }
        if ((n6 & 0x100) != 0) {
            bl = true;
        }
        this(string, n, font, n2, n3, f, n4, n5, bl);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    public final void setContent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.content = string;
    }

    public final int getLineSpace() {
        return this.lineSpace;
    }

    public final void setLineSpace(int n) {
        this.lineSpace = n;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    public final void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.font = font;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final int getBgColor() {
        return this.bgColor;
    }

    public final float getBgRadius() {
        return this.bgRadius;
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    public final int getMargin() {
        return this.margin;
    }

    public final void setMargin(int n) {
        this.margin = n;
    }

    public final boolean getCenter() {
        return this.center;
    }

    public final void setCenter(boolean bl) {
        this.center = bl;
    }

    public final float getW() {
        return this.w;
    }

    public final void setW(float f) {
        this.w = f;
    }

    public final float getH() {
        return this.h;
    }

    public final void setH(float f) {
        this.h = f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Float, Float> size(int minWidth, int maxWidth) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair<List<TextLine>, Float> pair = DrawElementKt.splitByWidth(this.content, maxWidth - (this.padding + this.margin) * 2, this.font, this.padding);
        List lines = (List)pair.component1();
        float width = ((Number)pair.component2()).floatValue();
        this.lines = lines;
        this.w = width;
        Iterable iterable = lines;
        TextLineBlock textLineBlock = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextLine textLine = (TextLine)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(it.getDescent() - it.getAscent()));
        }
        textLineBlock.h = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv)) + (float)((lines.size() - 1) * this.lineSpace);
        return TuplesKt.to((Object)Float.valueOf(width + (float)((this.padding + this.margin) * 2)), (Object)Float.valueOf(this.h + (float)(this.margin + this.padding) * 2.0f));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawToBoard(@NotNull Canvas canvas, @NotNull Pointer pointer, @NotNull Paint paint, int width, int imagePadding, boolean debug) {
        void $this$drawToBoard_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Paint paint2 = paint;
        Paint paint3 = paint2;
        RRect rRect = RRect.Companion.makeXYWH(this.center ? ((float)(width + 2 * imagePadding) - this.w - (float)this.margin - (float)this.padding) / 2.0f : pointer.getX() + (float)this.margin, pointer.getY() + (float)this.margin, this.w + 2.0f * (float)this.padding, this.h + 2.0f * (float)this.padding, this.bgRadius);
        Canvas canvas2 = canvas;
        boolean bl = false;
        $this$drawToBoard_u24lambda_u241.setColor(this.bgColor);
        Unit unit = Unit.INSTANCE;
        canvas2.drawRRect(rRect, paint2);
        pointer.setY(pointer.getY() + (float)(this.padding + this.margin));
        for (TextLine line : this.lines) {
            void it;
            Paint paint4;
            pointer.setY(pointer.getY() - line.getAscent());
            Paint paint5 = paint4 = paint;
            float f = pointer.getY();
            float f2 = this.center ? ((float)(width + 2 * imagePadding) - line.getWidth()) / (float)2 : pointer.getX() + (float)this.padding + (float)this.margin;
            rRect = line;
            canvas2 = canvas;
            boolean bl2 = false;
            it.setColor(this.color);
            Unit unit2 = Unit.INSTANCE;
            canvas2.drawTextLine((TextLine)rRect, f2, f, paint4);
            pointer.setY(pointer.getY() + (line.getDescent() + (float)this.lineSpace));
        }
        pointer.setY(pointer.getY() + (float)(this.padding + this.margin - this.lineSpace));
    }
}

