/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.draw.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.TextLine;
import top.e404.skiko.draw.DrawElement;
import top.e404.skiko.draw.Pointer;
import top.e404.skiko.util.Colors;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u00017BY\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ8\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\rH\u0016J$\u00103\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u0002040\u00042\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006H\u0016R\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R,\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0015\"\u0004\b'\u0010\u0017\u00a8\u00068"}, d2={"Ltop/e404/skiko/draw/element/TextColorful;", "Ltop/e404/skiko/draw/DrawElement;", "content", "", "Lkotlin/Pair;", "", "", "font", "Lorg/jetbrains/skia/Font;", "color", "udPadding", "left", "textIndent", "", "center", "(Ljava/util/List;Lorg/jetbrains/skia/Font;IIIZZ)V", "getCenter", "()Z", "setCenter", "(Z)V", "getColor", "()I", "setColor", "(I)V", "getContent", "()Ljava/util/List;", "setContent", "(Ljava/util/List;)V", "getFont", "()Lorg/jetbrains/skia/Font;", "setFont", "(Lorg/jetbrains/skia/Font;)V", "getLeft", "setLeft", "lines", "Ltop/e404/skiko/draw/element/TextColorful$LineInfo;", "getTextIndent", "setTextIndent", "getUdPadding", "setUdPadding", "drawToBoard", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "pointer", "Ltop/e404/skiko/draw/Pointer;", "paint", "Lorg/jetbrains/skia/Paint;", "width", "imagePadding", "debug", "size", "", "minWidth", "maxWidth", "LineInfo", "skiko-util-draw"})
@SourceDebugExtension(value={"SMAP\nTextColorful.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextColorful.kt\ntop/e404/skiko/draw/element/TextColorful\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1549#2:133\n1620#2,3:134\n1774#2,4:137\n1#3:141\n*S KotlinDebug\n*F\n+ 1 TextColorful.kt\ntop/e404/skiko/draw/element/TextColorful\n*L\n69#1:133\n69#1:134,3\n99#1:137,4\n*E\n"})
public class TextColorful
implements DrawElement {
    @NotNull
    private List<Pair<String, Integer>> content;
    @NotNull
    private Font font;
    private int color;
    private int udPadding;
    private int left;
    private boolean textIndent;
    private boolean center;
    @NotNull
    private final List<LineInfo> lines;

    public TextColorful(@NotNull List<Pair<String, Integer>> content, @NotNull Font font, int color, int udPadding, int left, boolean textIndent, boolean center) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.content = content;
        this.font = font;
        this.color = color;
        this.udPadding = udPadding;
        this.left = left;
        this.textIndent = textIndent;
        this.center = center;
        this.lines = new ArrayList();
    }

    public /* synthetic */ TextColorful(List list, Font font, int n, int n2, int n3, boolean bl, boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = Colors.WHITE.getArgb();
        }
        if ((n4 & 8) != 0) {
            n2 = 20;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            bl = false;
        }
        if ((n4 & 0x40) != 0) {
            bl2 = true;
        }
        this(list, font, n, n2, n3, bl, bl2);
    }

    @NotNull
    public final List<Pair<String, Integer>> getContent() {
        return this.content;
    }

    public final void setContent(@NotNull List<Pair<String, Integer>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.content = list;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    public final void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.font = font;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final int getUdPadding() {
        return this.udPadding;
    }

    public final void setUdPadding(int n) {
        this.udPadding = n;
    }

    public final int getLeft() {
        return this.left;
    }

    public final void setLeft(int n) {
        this.left = n;
    }

    public final boolean getTextIndent() {
        return this.textIndent;
    }

    public final void setTextIndent(boolean bl) {
        this.textIndent = bl;
    }

    public final boolean getCenter() {
        return this.center;
    }

    public final void setCenter(boolean bl) {
        this.center = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Float, Float> size(int minWidth, int maxWidth) {
        void $this$size_u24lambda_u241;
        int n;
        if (!this.center && this.textIndent) {
            this.content.add(0, (Pair<String, Integer>)TuplesKt.to((Object)"\u3000\u3000", (Object)0));
        }
        int left = this.center ? 0 : this.left;
        float currentMaxWidth = 0.0f;
        for (Pair<String, Integer> pair : this.content) {
            void $this$mapTo$iv$iv;
            String text = (String)pair.component1();
            int color = ((Number)pair.component2()).intValue();
            String[] stringArray = new String[]{"\n"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new LineInfo((String)it, color, true));
            }
            List list = (List)destination$iv$iv;
            ((LineInfo)CollectionsKt.last((List)list)).setNext(false);
            this.lines.addAll(list);
        }
        int i = 0;
        float w = maxWidth;
        while (i < this.lines.size() - 1) {
            LineInfo c = this.lines.get(++i);
            Pair<LineInfo, LineInfo> color = c.splitByWidth(w, this.font);
            LineInfo l1 = (LineInfo)color.component1();
            LineInfo l2 = (LineInfo)color.component2();
            if (l2 == null) {
                w -= this.font.measureTextWidth(l1.getLine());
                if (l1.getNext()) {
                    w = maxWidth;
                    continue;
                }
                if (!((float)maxWidth - w > currentMaxWidth)) continue;
                currentMaxWidth = (float)maxWidth - w;
                continue;
            }
            this.lines.set(i, l1);
            this.lines.set(i + 1, l2);
            w = maxWidth;
        }
        Iterable $this$count$iv = this.lines;
        boolean $i$f$count22 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LineInfo p0 = (LineInfo)element$iv;
                boolean bl = false;
                if (!p0.getNext() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        FontMetrics $i$f$count22 = this.font.getMetrics();
        float f = n;
        boolean bl = false;
        float f2 = $this$size_u24lambda_u241.getDescent() - $this$size_u24lambda_u241.getAscent();
        float height = f * (f2 + (float)this.udPadding);
        return TuplesKt.to((Object)Float.valueOf(currentMaxWidth + (float)left), (Object)Float.valueOf(height));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawToBoard(@NotNull Canvas canvas, @NotNull Pointer pointer, @NotNull Paint paint, int width, int imagePadding, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        float x = pointer.getX();
        pointer.setY(pointer.getY() + ((float)(this.udPadding / 2) - this.font.getMetrics().getAscent()));
        for (LineInfo lineInfo : this.lines) {
            FontMetrics it;
            Paint paint2;
            String text = lineInfo.component1();
            int color = lineInfo.component2();
            boolean next = lineInfo.component3();
            TextLine line = TextLine.Companion.make(text, this.font);
            Paint paint3 = paint2 = paint;
            float f = pointer.getY();
            float f2 = this.center ? ((float)(width + imagePadding * 2) - line.getWidth()) / (float)2 : pointer.getX() + (float)this.left;
            TextLine textLine = line;
            Object object = canvas;
            boolean bl = false;
            it.setColor(color);
            Unit unit = Unit.INSTANCE;
            object.drawTextLine(textLine, f2, f, paint2);
            if (next) {
                void $this$drawToBoard_u24lambda_u243;
                pointer.setX(x);
                it = this.font.getMetrics();
                float f3 = pointer.getY();
                object = pointer;
                boolean bl2 = false;
                f2 = $this$drawToBoard_u24lambda_u243.getDescent() - $this$drawToBoard_u24lambda_u243.getAscent();
                ((Pointer)object).setY(f3 + (f2 + (float)this.udPadding));
                continue;
            }
            pointer.setX(pointer.getX() + line.getWidth());
        }
        pointer.setX(x);
        pointer.setY(pointer.getY() + ((float)(this.udPadding / 2) + this.font.getMetrics().getAscent()));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J(\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001J$\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00000 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Ltop/e404/skiko/draw/element/TextColorful$LineInfo;", "", "line", "", "color", "", "next", "", "(Ljava/lang/String;IZ)V", "getColor", "()I", "getLine", "()Ljava/lang/String;", "getNext", "()Z", "setNext", "(Z)V", "component1", "component2", "component3", "copy", "equals", "other", "getSplitIndex", "widthLimit", "", "font", "Lorg/jetbrains/skia/Font;", "startIndex", "endIndex", "hashCode", "splitByWidth", "Lkotlin/Pair;", "toString", "skiko-util-draw"})
    public static final class LineInfo {
        @NotNull
        private final String line;
        private final int color;
        private boolean next;

        public LineInfo(@NotNull String line, int color, boolean next) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.line = line;
            this.color = color;
            this.next = next;
        }

        @NotNull
        public final String getLine() {
            return this.line;
        }

        public final int getColor() {
            return this.color;
        }

        public final boolean getNext() {
            return this.next;
        }

        public final void setNext(boolean bl) {
            this.next = bl;
        }

        @NotNull
        public final Pair<LineInfo, LineInfo> splitByWidth(float widthLimit, @NotNull Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            if (font.measureTextWidth(this.line) < widthLimit) {
                return TuplesKt.to((Object)this, null);
            }
            int index = this.getSplitIndex(widthLimit, font, 0, this.line.length());
            String string = this.line.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            LineInfo lineInfo = new LineInfo(string, this.color, true);
            String string2 = this.line.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            return TuplesKt.to((Object)lineInfo, (Object)new LineInfo(string2, this.color, this.next));
        }

        private final int getSplitIndex(float widthLimit, Font font, int startIndex, int endIndex) {
            if (startIndex == endIndex) {
                return startIndex;
            }
            int half = startIndex + (endIndex - startIndex) / 2;
            if (half == startIndex || half == endIndex) {
                return startIndex;
            }
            String string = this.line.substring(0, half);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            float current = font.measureTextWidth(string);
            return current > widthLimit ? this.getSplitIndex(widthLimit, font, startIndex, half) : this.getSplitIndex(widthLimit, font, half, endIndex);
        }

        @NotNull
        public final String component1() {
            return this.line;
        }

        public final int component2() {
            return this.color;
        }

        public final boolean component3() {
            return this.next;
        }

        @NotNull
        public final LineInfo copy(@NotNull String line, int color, boolean next) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return new LineInfo(line, color, next);
        }

        public static /* synthetic */ LineInfo copy$default(LineInfo lineInfo, String string, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = lineInfo.line;
            }
            if ((n2 & 2) != 0) {
                n = lineInfo.color;
            }
            if ((n2 & 4) != 0) {
                bl = lineInfo.next;
            }
            return lineInfo.copy(string, n, bl);
        }

        @NotNull
        public String toString() {
            return "LineInfo(line=" + this.line + ", color=" + this.color + ", next=" + this.next + ")";
        }

        public int hashCode() {
            int result = this.line.hashCode();
            result = result * 31 + Integer.hashCode(this.color);
            int n = this.next ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineInfo)) {
                return false;
            }
            LineInfo lineInfo = (LineInfo)other;
            if (!Intrinsics.areEqual((Object)this.line, (Object)lineInfo.line)) {
                return false;
            }
            if (this.color != lineInfo.color) {
                return false;
            }
            return this.next == lineInfo.next;
        }
    }
}

