/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.gif;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.AnimationDisposalMode;
import org.jetbrains.skia.AnimationFrameInfo;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.BlendMode;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.IRect;
import top.e404.skiko.gif.ApplicationExtension;
import top.e404.skiko.gif.AtkinsonDitherer;
import top.e404.skiko.gif.ColorTable;
import top.e404.skiko.gif.GIFBuilder;
import top.e404.skiko.gif.GraphicControlExtension;
import top.e404.skiko.gif.ImageDescriptor;
import top.e404.skiko.gif.LogicalScreenDescriptor;
import top.e404.skiko.gif.OctTreeQuantizer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 >2\u00020\u0001:\u0001>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J \u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000e2\b\b\u0002\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u0010J3\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000e2\b\b\u0002\u00100\u001a\u00020\u000f2\u0019\b\u0002\u00102\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020403\u00a2\u0006\u0002\b5J\u0018\u00106\u001a\n 7*\u0004\u0018\u00010+0+2\u0006\u00108\u001a\u00020+H\u0002J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0003J\u001f\u0010\u001f\u001a\u00020\u00002\u0017\u00102\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020403\u00a2\u0006\u0002\b5J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0003J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000eJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u000fJ\u0018\u0010=\u001a\n 7*\u0004\u0018\u00010+0+2\u0006\u00108\u001a\u00020+H\u0002R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nRN\u0010\u000b\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\r0\fj\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\r`\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u001a\u0010\u001c\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\b\"\u0004\b\u001e\u0010\nR\u001a\u0010\u001f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\b\"\u0004\b&\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\b\u00a8\u0006?"}, d2={"Ltop/e404/skiko/gif/GIFBuilder;", "", "width", "", "height", "(II)V", "buffering", "getBuffering", "()I", "setBuffering", "(I)V", "frames", "Ljava/util/ArrayList;", "Lkotlin/Triple;", "Lorg/jetbrains/skia/Bitmap;", "Ltop/e404/skiko/gif/ColorTable;", "Lorg/jetbrains/skia/AnimationFrameInfo;", "Lkotlin/collections/ArrayList;", "getFrames", "()Ljava/util/ArrayList;", "setFrames", "(Ljava/util/ArrayList;)V", "global", "getGlobal", "()Ltop/e404/skiko/gif/ColorTable;", "setGlobal", "(Ltop/e404/skiko/gif/ColorTable;)V", "getHeight", "loop", "getLoop", "setLoop", "options", "getOptions", "()Lorg/jetbrains/skia/AnimationFrameInfo;", "setOptions", "(Lorg/jetbrains/skia/AnimationFrameInfo;)V", "ratio", "getRatio", "setRatio", "getWidth", "open", "", "buildToBuffer", "Ljava/nio/ByteBuffer;", "buildToData", "Lorg/jetbrains/skia/Data;", "frame", "bitmap", "colors", "info", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "header", "kotlin.jvm.PlatformType", "buffer", "count", "size", "table", "value", "trailer", "Companion", "skiko-util-gif-codec"})
public final class GIFBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    private int loop;
    private int buffering;
    private int ratio;
    @NotNull
    private ColorTable global;
    @NotNull
    private AnimationFrameInfo options;
    @NotNull
    private ArrayList<Triple<Bitmap, ColorTable, AnimationFrameInfo>> frames;
    @NotNull
    private static final byte[] GIF_HEADER;
    @NotNull
    private static final byte[] GIF_TRAILER;

    public GIFBuilder(int width, int height) {
        this.width = width;
        this.height = height;
        this.global = ColorTable.Companion.getEmpty();
        this.options = new AnimationFrameInfo(-1, 1000, false, ColorAlphaType.OPAQUE, false, AnimationDisposalMode.UNUSED, BlendMode.CLEAR, IRect.Companion.makeXYWH(0, 0, 0, 0));
        this.frames = new ArrayList();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    private final ByteBuffer header(ByteBuffer buffer) {
        return buffer.put(GIF_HEADER);
    }

    private final ByteBuffer trailer(ByteBuffer buffer) {
        return buffer.put(GIF_TRAILER);
    }

    public final int getLoop() {
        return this.loop;
    }

    public final void setLoop(int n) {
        this.loop = n;
    }

    @NotNull
    public final GIFBuilder loop(int count) {
        GIFBuilder gIFBuilder;
        GIFBuilder $this$loop_u24lambda_u240 = gIFBuilder = this;
        boolean bl = false;
        $this$loop_u24lambda_u240.loop = count;
        return gIFBuilder;
    }

    public final int getBuffering() {
        return this.buffering;
    }

    public final void setBuffering(int n) {
        this.buffering = n;
    }

    @NotNull
    public final GIFBuilder buffering(boolean open) {
        GIFBuilder gIFBuilder;
        GIFBuilder $this$buffering_u24lambda_u241 = gIFBuilder = this;
        boolean bl = false;
        $this$buffering_u24lambda_u241.buffering = open ? 65536 : 0;
        return gIFBuilder;
    }

    public final int getRatio() {
        return this.ratio;
    }

    public final void setRatio(int n) {
        this.ratio = n;
    }

    @NotNull
    public final GIFBuilder ratio(int size) {
        GIFBuilder gIFBuilder;
        GIFBuilder $this$ratio_u24lambda_u242 = gIFBuilder = this;
        boolean bl = false;
        $this$ratio_u24lambda_u242.ratio = size;
        return gIFBuilder;
    }

    @NotNull
    public final ColorTable getGlobal() {
        return this.global;
    }

    public final void setGlobal(@NotNull ColorTable colorTable) {
        Intrinsics.checkNotNullParameter((Object)colorTable, (String)"<set-?>");
        this.global = colorTable;
    }

    @NotNull
    public final GIFBuilder table(@NotNull Bitmap bitmap) {
        GIFBuilder gIFBuilder;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        GIFBuilder $this$table_u24lambda_u243 = gIFBuilder = this;
        boolean bl = false;
        $this$table_u24lambda_u243.global = new ColorTable(new OctTreeQuantizer().quantize(bitmap, 256), true, 0, 0, 12, null);
        return gIFBuilder;
    }

    @NotNull
    public final GIFBuilder table(@NotNull ColorTable value) {
        GIFBuilder gIFBuilder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GIFBuilder $this$table_u24lambda_u244 = gIFBuilder = this;
        boolean bl = false;
        $this$table_u24lambda_u244.global = value;
        return gIFBuilder;
    }

    @NotNull
    public final AnimationFrameInfo getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull AnimationFrameInfo animationFrameInfo) {
        Intrinsics.checkNotNullParameter((Object)animationFrameInfo, (String)"<set-?>");
        this.options = animationFrameInfo;
    }

    @NotNull
    public final GIFBuilder options(@NotNull Function1<? super AnimationFrameInfo, Unit> block) {
        GIFBuilder gIFBuilder;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        GIFBuilder $this$options_u24lambda_u245 = gIFBuilder = this;
        boolean bl = false;
        AnimationFrameInfo animationFrameInfo = $this$options_u24lambda_u245.options;
        block.invoke((Object)animationFrameInfo);
        return gIFBuilder;
    }

    @NotNull
    public final ArrayList<Triple<Bitmap, ColorTable, AnimationFrameInfo>> getFrames() {
        return this.frames;
    }

    public final void setFrames(@NotNull ArrayList<Triple<Bitmap, ColorTable, AnimationFrameInfo>> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.frames = arrayList;
    }

    @NotNull
    public final GIFBuilder frame(@NotNull Bitmap bitmap, @NotNull ColorTable colors, @NotNull Function1<? super AnimationFrameInfo, Unit> block) {
        GIFBuilder gIFBuilder;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        GIFBuilder $this$frame_u24lambda_u246 = gIFBuilder = this;
        boolean bl = false;
        IRect rect = IRect.Companion.makeXYWH(0, 0, bitmap.getWidth(), bitmap.getHeight());
        ArrayList<Triple<Bitmap, ColorTable, AnimationFrameInfo>> arrayList = $this$frame_u24lambda_u246.frames;
        AnimationFrameInfo animationFrameInfo = $this$frame_u24lambda_u246.options.withFrameRect(rect);
        block.invoke((Object)animationFrameInfo);
        arrayList.add((Triple<Bitmap, ColorTable, AnimationFrameInfo>)new Triple((Object)bitmap, (Object)colors, (Object)animationFrameInfo));
        return gIFBuilder;
    }

    public static /* synthetic */ GIFBuilder frame$default(GIFBuilder gIFBuilder, Bitmap bitmap, ColorTable colorTable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            colorTable = ColorTable.Companion.getEmpty();
        }
        if ((n & 4) != 0) {
            function1 = frame.1.INSTANCE;
        }
        return gIFBuilder.frame(bitmap, colorTable, (Function1<? super AnimationFrameInfo, Unit>)function1);
    }

    @NotNull
    public final GIFBuilder frame(@NotNull Bitmap bitmap, @NotNull ColorTable colors, @NotNull AnimationFrameInfo info) {
        GIFBuilder gIFBuilder;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        GIFBuilder $this$frame_u24lambda_u247 = gIFBuilder = this;
        boolean bl = false;
        $this$frame_u24lambda_u247.frames.add((Triple<Bitmap, ColorTable, AnimationFrameInfo>)new Triple((Object)bitmap, (Object)colors, (Object)info));
        return gIFBuilder;
    }

    public static /* synthetic */ GIFBuilder frame$default(GIFBuilder gIFBuilder, Bitmap bitmap, ColorTable colorTable, AnimationFrameInfo animationFrameInfo, int n, Object object) {
        if ((n & 2) != 0) {
            colorTable = ColorTable.Companion.getEmpty();
        }
        return gIFBuilder.frame(bitmap, colorTable, animationFrameInfo);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteBuffer buildToBuffer() {
        int n;
        List list2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ByteBuffer>>, Object>(this, null){
            int label;
            final /* synthetic */ GIFBuilder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable iterable = this.this$0.getFrames();
                        GIFBuilder gIFBuilder = this.this$0;
                        boolean $i$f$map = false;
                        void var5_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            Triple triple = (Triple)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Bitmap bitmap = (Bitmap)triple.component1();
                            ColorTable colors = (ColorTable)triple.component2();
                            AnimationFrameInfo info = (AnimationFrameInfo)triple.component3();
                            collection.add(BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ByteBuffer>, Object>(bitmap, colors, gIFBuilder, info, null){
                                int label;
                                final /* synthetic */ Bitmap $bitmap;
                                final /* synthetic */ ColorTable $colors;
                                final /* synthetic */ GIFBuilder this$0;
                                final /* synthetic */ AnimationFrameInfo $info;
                                {
                                    this.$bitmap = $bitmap;
                                    this.$colors = $colors;
                                    this.this$0 = $receiver;
                                    this.$info = $info;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            boolean opaque = !this.$bitmap.computeIsOpaque();
                                            ColorTable table = this.$colors.exists() ? this.$colors : (this.this$0.getGlobal().exists() ? this.this$0.getGlobal() : new ColorTable(new OctTreeQuantizer().quantize(this.$bitmap, opaque ? 255 : 256), true, 0, 0, 12, null));
                                            Integer transparency = opaque ? Boxing.boxInt((int)table.getTransparency()) : null;
                                            int[] result2 = AtkinsonDitherer.INSTANCE.dither(this.$bitmap, table.getColors());
                                            ByteBuffer descBuf = ImageDescriptor.INSTANCE.toBuffer(this.$info.getFrameRect$skiko(), table, table != this.this$0.getGlobal(), result2);
                                            ByteBuffer buf = ByteBuffer.allocate(descBuf.limit() + 8);
                                            buf.order(ByteOrder.LITTLE_ENDIAN);
                                            Intrinsics.checkNotNullExpressionValue((Object)buf, (String)"buf");
                                            GraphicControlExtension.INSTANCE.write(buf, this.$info.getDisposalMethod(), false, transparency, this.$info.getDuration());
                                            int n = descBuf.position();
                                            for (int i = 0; i < n; ++i) {
                                                buf.put(descBuf.get(i));
                                            }
                                            return buf;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ByteBuffer> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.label = 1;
                        Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends ByteBuffer>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Iterable iterable = list2;
        int n2 = GIF_HEADER.length + this.global.s() + 7;
        int n3 = 0;
        for (Object object : iterable) {
            void it;
            ByteBuffer byteBuffer = (ByteBuffer)object;
            n = n3;
            boolean bl = false;
            int n4 = it.limit();
            n3 = n + n4;
        }
        n = n3;
        int size = n2 + n + GIF_TRAILER.length;
        if (this.loop >= 0) {
            size += 19;
        }
        if (this.buffering > 0) {
            size += 21;
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        Intrinsics.checkNotNullExpressionValue((Object)buf, (String)"buf");
        this.header(buf);
        LogicalScreenDescriptor.INSTANCE.write(buf, this.width, this.height, this.global, this.ratio);
        if (this.loop >= 0) {
            ApplicationExtension.INSTANCE.loop(buf, this.loop);
        }
        if (this.buffering > 0) {
            ApplicationExtension.INSTANCE.buffering(buf, this.buffering);
        }
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ByteBuffer it = (ByteBuffer)element$iv;
            boolean bl = false;
            int n5 = it.position();
            for (int i = 0; i < n5; ++i) {
                buf.put(it.get(i));
            }
        }
        this.trailer(buf);
        return buf;
    }

    @NotNull
    public final Data buildToData() {
        byte[] byArray = this.buildToBuffer().array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buildToBuffer().array()");
        return Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])byArray, (int)0, (int)0, (int)6, null);
    }

    static {
        byte[] byArray = "GIF89a".getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        GIF_HEADER = byArray;
        byte[] byArray2 = ";".getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        GIF_TRAILER = byArray2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ltop/e404/skiko/gif/GIFBuilder$Companion;", "", "()V", "GIF_HEADER", "", "getGIF_HEADER$skiko_util_gif_codec", "()[B", "GIF_TRAILER", "getGIF_TRAILER$skiko_util_gif_codec", "skiko-util-gif-codec"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getGIF_HEADER$skiko_util_gif_codec() {
            return GIF_HEADER;
        }

        @NotNull
        public final byte[] getGIF_TRAILER$skiko_util_gif_codec() {
            return GIF_TRAILER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

