/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.gif;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.IRect;
import top.e404.skiko.gif.ColorTable;
import top.e404.skiko.gif.LZWEncoder;
import top.e404.skiko.gif.UtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J&\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ5\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltop/e404/skiko/gif/ImageDescriptor;", "", "()V", "SEPARATOR", "", "TERMINATOR", "block", "", "buffer", "Ljava/nio/ByteBuffer;", "left", "", "top", "width", "height", "flags", "", "data", "min", "", "size", "toBuffer", "rect", "Lorg/jetbrains/skia/IRect;", "table", "Ltop/e404/skiko/gif/ColorTable;", "local", "", "image", "", "write", "write$skiko_util_gif_codec", "skiko-util-gif-codec"})
public final class ImageDescriptor {
    @NotNull
    public static final ImageDescriptor INSTANCE = new ImageDescriptor();
    private static final int SEPARATOR = 44;
    private static final int TERMINATOR = 0;

    private ImageDescriptor() {
    }

    private final void block(ByteBuffer buffer, short left, short top, short width, short height, byte flags) {
        buffer.put(UtilKt.asUnsignedByte(44));
        buffer.putShort(left);
        buffer.putShort(top);
        buffer.putShort(width);
        buffer.putShort(height);
        buffer.put(flags);
    }

    private final void data(ByteBuffer buffer, int min, byte[] data) {
        buffer.put(UtilKt.asUnsignedByte(min));
        int n = data.length + -1;
        int index = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)255);
        if (index <= n2) {
            while (true) {
                int size = Math.min(data.length - index, 255);
                buffer.put(UtilKt.asUnsignedByte(size));
                buffer.put(data, index, size);
                if (index == n2) break;
                index += 255;
            }
        }
    }

    public final void write$skiko_util_gif_codec(@NotNull ByteBuffer buffer, @NotNull IRect rect, @NotNull ColorTable table, boolean local, @NotNull int[] image) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int flags = 0;
        if (local) {
            flags = 0x80 | table.size();
            if (table.getSort()) {
                flags |= 0x10;
            }
        }
        this.block(buffer, UtilKt.asUnsignedShort(rect.getLeft()), UtilKt.asUnsignedShort(rect.getTop()), UtilKt.asUnsignedShort(rect.getWidth()), UtilKt.asUnsignedShort(rect.getHeight()), UtilKt.asUnsignedByte(flags));
        if (local) {
            table.write(buffer);
        }
        Pair<Integer, byte[]> pair = new LZWEncoder(table, image).encode();
        int min = ((Number)pair.component1()).intValue();
        byte[] lzw = (byte[])pair.component2();
        this.data(buffer, min, lzw);
        buffer.put(UtilKt.asUnsignedByte(0));
    }

    private final int size(byte[] data) {
        int s = 1;
        int index = 0;
        int n = data.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)255);
        if (index <= n2) {
            while (true) {
                int size = Math.min(data.length - index, 255);
                ++s;
                s += size;
                if (index == n2) break;
                index += 255;
            }
        }
        return s;
    }

    @NotNull
    public final ByteBuffer toBuffer(@NotNull IRect rect, @NotNull ColorTable table, boolean local, @NotNull int[] image) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Pair<Integer, byte[]> pair = new LZWEncoder(table, image).encode();
        int min = ((Number)pair.component1()).intValue();
        byte[] lzw = (byte[])pair.component2();
        int flags = 0;
        if (local) {
            flags = 0x80 | table.size();
            if (table.getSort()) {
                flags |= 0x10;
            }
        }
        int s = this.size(lzw);
        ByteBuffer buffer = ByteBuffer.allocate(11 + table.s() + s);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        this.block(buffer, UtilKt.asUnsignedShort(rect.getLeft()), UtilKt.asUnsignedShort(rect.getTop()), UtilKt.asUnsignedShort(rect.getWidth()), UtilKt.asUnsignedShort(rect.getHeight()), UtilKt.asUnsignedByte(flags));
        if (local) {
            table.write(buffer);
        }
        this.data(buffer, min, lzw);
        buffer.put(UtilKt.asUnsignedByte(0));
        return buffer;
    }
}

