/*
 * Decompiled with CFR 0.152.
 */
package top.e404.skiko.gif;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import top.e404.skiko.gif.ColorTable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltop/e404/skiko/gif/LZWEncoder;", "", "colors", "Ltop/e404/skiko/gif/ColorTable;", "image", "", "(Ltop/e404/skiko/gif/ColorTable;[I)V", "codeSize", "", "indexBuffer", "", "minimumCodeSize", "outputBits", "Ljava/util/BitSet;", "position", "table", "", "addCodeToTable", "", "indices", "encode", "Lkotlin/Pair;", "", "processIndex", "index", "resetCodeTableAndCodeSize", "toBytes", "writeCode", "code", "Companion", "skiko-util-gif-codec"})
public final class LZWEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorTable colors;
    @NotNull
    private final int[] image;
    private final int minimumCodeSize;
    @NotNull
    private final BitSet outputBits;
    private int position;
    @NotNull
    private final Map<List<Integer>, Integer> table;
    private int codeSize;
    @NotNull
    private List<Integer> indexBuffer;
    @NotNull
    private static final List<Integer> CLEAR_CODE = CollectionsKt.listOf((Object)-1);
    @NotNull
    private static final List<Integer> END_OF_INFO = CollectionsKt.listOf((Object)-2);
    public static final int MAX_CODE_TABLE_SIZE = 4096;

    public LZWEncoder(@NotNull ColorTable colors, @NotNull int[] image) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.colors = colors;
        this.image = image;
        this.minimumCodeSize = this.colors.size() + 1;
        this.outputBits = new BitSet();
        this.table = new HashMap();
        this.indexBuffer = CollectionsKt.emptyList();
        this.resetCodeTableAndCodeSize();
    }

    @NotNull
    public final Pair<Integer, byte[]> encode() {
        this.writeCode(((Number)MapsKt.getValue(this.table, CLEAR_CODE)).intValue());
        for (int rgb : this.image) {
            int index = ArraysKt.indexOf((int[])this.colors.getColors(), (int)rgb);
            this.processIndex(index != -1 ? index : this.colors.getTransparency());
        }
        this.writeCode(((Number)MapsKt.getValue(this.table, this.indexBuffer)).intValue());
        this.writeCode(((Number)MapsKt.getValue(this.table, END_OF_INFO)).intValue());
        return TuplesKt.to((Object)this.minimumCodeSize, (Object)this.toBytes());
    }

    private final void processIndex(int index) {
        List list2;
        List extendedIndexBuffer = CollectionsKt.plus((Collection)this.indexBuffer, (Object)index);
        if (this.table.containsKey(extendedIndexBuffer)) {
            list2 = extendedIndexBuffer;
        } else {
            this.writeCode(((Number)MapsKt.getValue(this.table, this.indexBuffer)).intValue());
            if (this.table.size() == 4096) {
                this.writeCode(((Number)MapsKt.getValue(this.table, CLEAR_CODE)).intValue());
                this.resetCodeTableAndCodeSize();
            } else {
                this.addCodeToTable(extendedIndexBuffer);
            }
            list2 = CollectionsKt.listOf((Object)index);
        }
        this.indexBuffer = list2;
    }

    private final void writeCode(int code) {
        int n = this.codeSize;
        for (int shift = 0; shift < n; ++shift) {
            boolean bit = (code >>> shift & 1) != 0;
            int n2 = this.position;
            this.position = n2 + 1;
            this.outputBits.set(n2, bit);
        }
    }

    private final byte[] toBytes() {
        int bitCount = this.position;
        byte[] result2 = new byte[(bitCount + 7) / 8];
        for (int i = 0; i < bitCount; ++i) {
            int byteIndex = i / 8;
            int bitIndex = i % 8;
            result2[byteIndex] = (byte)((this.outputBits.get(i) ? 1 : 0) << bitIndex | result2[byteIndex]);
        }
        return result2;
    }

    private final void addCodeToTable(List<Integer> indices) {
        int newCode = this.table.size();
        Integer n = newCode;
        this.table.put(indices, n);
        if (newCode == 1 << this.codeSize) {
            ++this.codeSize;
        }
    }

    private final void resetCodeTableAndCodeSize() {
        this.table.clear();
        int colorsInCodeTable = 1 << this.minimumCodeSize;
        for (int i = 0; i < colorsInCodeTable; ++i) {
            Integer n = i;
            this.table.put(CollectionsKt.listOf((Object)i), n);
        }
        this.table.put(CLEAR_CODE, this.table.size());
        this.table.put(END_OF_INFO, this.table.size());
        this.codeSize = this.minimumCodeSize + 1;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltop/e404/skiko/gif/LZWEncoder$Companion;", "", "()V", "CLEAR_CODE", "", "", "getCLEAR_CODE", "()Ljava/util/List;", "END_OF_INFO", "getEND_OF_INFO", "MAX_CODE_TABLE_SIZE", "skiko-util-gif-codec"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getCLEAR_CODE() {
            return CLEAR_CODE;
        }

        @NotNull
        public final List<Integer> getEND_OF_INFO() {
            return END_OF_INFO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

